% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distrr_funs.R, R/dcc_new.R
\name{dcc}
\alias{dcc}
\alias{dcc2}
\alias{dcc5}
\title{Data cube creation (dcc)}
\usage{
dcc(.data, .variables, .fun = jointfun_, ...)

dcc2(.data, .variables, .fun = jointfun_, order_type = extract_unique2,
  ...)

dcc5(.data, .variables, .fun = jointfun_, .total = "Totale",
  order_type = extract_unique4, .all = TRUE, ...)
}
\arguments{
\item{.data}{data frame to be processed}

\item{.variables}{variables to split data frame by, as a character vector 
(\code{c("var1", "var2")}).}

\item{.fun}{function to apply to each piece (default: \code{\link{jointfun_}})}

\item{...}{additional functions passed to \code{.fun}.}

\item{order_type}{a function like \code{\link{extract_unique}} or 
\code{\link{extract_unique2}}.}

\item{.total}{character string with the name to give to the subset of data
that includes all the observations of a variable (default: \code{"Totale"}).}

\item{.all}{logical, indicating if functions' have to be evaluated on the 
complete dataset.}
}
\value{
a data cube, with a column for each cateogrical variable used, and a row for each combination of all the categorical variables' modalities. In addition to all the modalities, each variable will also have a "Total" possibility, which includes all the others. The data cube will contain marginal, conditional and joint empirical distributions...
}
\description{
Data cube creation (dcc)
}
\examples{
data("invented_wages")
str(invented_wages)
tmp <- dcc(.data = invented_wages, 
           .variables = c("gender", "sector"), .fun = jointfun_)
tmp
str(tmp)
tmp2 <- dcc2(.data = invented_wages, 
            .variables = c("gender", "education"), 
            .fun = jointfun_, 
            order_type = extract_unique2)
tmp2
str(tmp2)

# dcc5 works like dcc2, but has an additional optional argument, .total,
# that can be added to give a name to the groups that include all the 
# observations of a variable.
tmp5 <- dcc5(.data = invented_wages, 
            .variables = c("gender", "education"),
            .fun = jointfun_,
            .total = "TOTAL",
            order_type = extract_unique2)
tmp5

}
