% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dm_wrap.R
\name{dm_wrap_tbl}
\alias{dm_wrap_tbl}
\title{Wrap dm into a single tibble dm}
\usage{
dm_wrap_tbl(dm, root, strict = TRUE)
}
\arguments{
\item{dm}{A cycle free dm object.}

\item{root}{Table to wrap the dm into (unquoted).}

\item{strict}{Whether to fail for cyclic dms that cannot be wrapped into a
single table, if \code{FALSE} a partially wrapped dm will be returned.}
}
\value{
A \code{dm} object.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

\code{dm_wrap_tbl()} creates a single tibble dm containing the \code{root} table
enhanced with all the data related to it
through the relationships stored in the dm.
It runs a sequence of \code{\link[=dm_nest_tbl]{dm_nest_tbl()}} and \code{\link[=dm_pack_tbl]{dm_pack_tbl()}} operations
on the dm.
}
\details{
\code{dm_wrap_tbl()} is an inverse to \code{dm_unwrap_tbl()},
i.e., wrapping after unwrapping returns the same information
(disregarding row and column order).
The opposite is not generally true:
since \code{dm_wrap_tbl()} keeps only rows related directly or indirectly to
rows in the \code{root} table.
Even if all referential constraints are satisfied,
unwrapping after wrapping loses rows in parent tables
that don't have a corresponding row in the child table.

This function differs from \code{dm_flatten_to_tbl()} and \code{dm_squash_to_tbl()} ,
which always return a single table, and not a \code{dm} object.
}
\examples{
dm_nycflights13() \%>\%
  dm_wrap_tbl(root = airlines)
}
\seealso{
\code{\link[=dm_unwrap_tbl]{dm_unwrap_tbl()}}, \code{\link[=dm_nest_tbl]{dm_nest_tbl()}},
\code{\link[=dm_examine_constraints]{dm_examine_constraints()}},
\code{\link[=dm_examine_cardinalities]{dm_examine_cardinalities()}}.
}
