\name{limit_cq}
\alias{limit_cq}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Limit Cy0 values
}
\description{
The function \code{limit_cq} calculates the Cq values of a qPCR experiment 
within a defined range of cycles. The function can be used to extract Cq 
values of a chamber based qPCR for conversion into a dPCR experiment. All 
Cq values are obtained by Second Derivative Maximum or by Cy0 method 
(Guescini et al. (2008)). }
\usage{
limit_cq(data = data, cyc = 1, fluo = NULL, 
	  Cq_range = c(1, max(data[cyc])), model = l5, SDM = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{data}{
a dataframe containing the qPCR data.
}
  \item{cyc}{
the column containing the cycle data. Defaults to first column.
}
  \item{fluo}{
        the column(s) (runs) to be analyzed. If NULL, all runs will be 
considered. Use fluo = 2 to chose the second column for example.
}
  \item{Cq_range}{
    is a user defined range of cycles to be used for the determination of 
the Cq values.
}
  \item{model}{
    is the model to be used for the analysis for all runs. Defaults to 
'l5' (see \code{\link[qpcR]{pcrfit}}).
}
  \item{SDM}{
    if \code{TRUE}, Cq is approximated by the second derivative method. 
    If \code{FALSE}, Cy0 method is used instead.
}
}
\details{
The \code{Cq_range} for this function an be defined be the user. The 
default is to take all amplification curves into consideration. However, 
under certain circumstances it is recommended to define a range. For 
example if amplifications are positive in early cycle numbers (less than 
10). 

Approximated second derivative is influenced both by how often interpolation
takes place in each data interval and by the smoothing method used. The user is
encouraged to seek optimal parameters for his data himself. See \code{\link[chipPCR]{inder}} 
for details.

The calculation of the Cy0 value (equivalent of Cq) is based on a 
five-parameter function. From experience this functions leads to good 
fitting and avoids overfitting of critical data sets. Regardless, the user 
is recommended to test for the optimal fitting function himself (see 
\code{\link[qpcR]{mselect}} for details).
}

\value{
A data frame with two columns and number of rows equal to the number of 
runs analyzed. The column \code{Cy0} contains calculated Cy0 values. The 
column \code{in.range} contains adequate logical constant if given Cy0 
value is in user-defined \code{Cq_range}.
}

\references{
Guescini M, Sisti D, Rocchi MB, Stocchi L & Stocchi V (2008) \emph{A new 
real-time PCR method to overcome significant quantitative inaccuracy due 
to slight amplification inhibition}. BMC Bioinformatics, 9: 326.

Ruijter JM, Pfaffl MW, Zhao S, et al. (2013) \emph{Evaluation of qPCR curve 
analysis methods for reliable biomarker discovery: bias, resolution, 
precision, and implications}. Methods, San Diego Calif 59:32--46.
}
\author{
Michal Burdukiewicz, Stefan Roediger.
}
\seealso{
SDM method: \code{\link[chipPCR]{inder}}, \code{\link[chipPCR]{summary.der}}.

Cy0 method: \code{\link[qpcR]{mselect}}, \code{\link[qpcR]{efficiency}}.
}
\examples{
library(qpcR)
test <- cbind(reps[1L:45, ], reps2[1L:45, 2L:ncol(reps2)], reps3[1L:45, 
	      2L:ncol(reps3)])

# results.dPCR contains a column with the Cy0 values and a column with 
# converted values.
Cq.range <- c(20, 30)
ranged <- limit_cq(data = test, cyc = 1, fluo = NULL,
                           Cq_range = Cq.range, model = l5)
# Same as above, but without Cq.range
no_range <- limit_cq(data = test, cyc = 1, fluo = NULL, model = l5)

}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ Cy0 }
\keyword{ qPCR }
\keyword{ dPCR }
