#' predict.tsd Estimate sex ratio according to constant incubation temperature
#' @title Estimate sex ratio according to constant incubation temperature
#' @author Marc Girondot
#' @return A data.frame with informations about sex-ratio
#' @param object A result file generated by tsd
#' @param temperatures A vector of temperatures
#' @param durations A vector of durations
#' @param SD.temperatures SD of temperatures
#' @param SD.durations SD of durations
#' @param resultmcmc A result of tsd_MHmcmc()
#' @param chain What chain to be used is resultmcmc is provided
#' @param probs The quantiles to be returned, default=c(0.025, 0.5, 0.975)
#' @param replicate.CI Number of replicates to estimate CI
#' @param ... Not used
#' @description Estimate sex ratio according to constant incubation temperature\cr
#' The data.frame has the following components:\cr
#' temperatures, SE, sexratio, CI.minus.sexratio, CI.plus.sexratio, range.CI\cr
#' Note that incubation duration is a very bad proxy for sex ratio. See Georges, 
#' A., Limpus, C. J. & Stoutjesdijk, R. 1994. Hatchling sex in the marine turtle 
#' Caretta caretta is determined by proportion of development at a temperature, 
#' not daily duration of exposure. J. Exp. Zool., 270, 432-444.
#' @family Functions for temperature-dependent sex determination
#' @examples
#' \dontrun{
#' library(embryogrowth)
#' m <- c(10, 14, 7, 4, 3, 0, 0)
#' f <- c(0, 1, 2, 4, 15, 10, 13)
#' t <- c(25, 26, 27, 28, 29, 30, 31)
#' result <- tsd(males=m, females=f, temperatures=t)
#' plot(result)
#' predict(result, temperatures=c(25, 31), replicate.CI = 10000)
#' predict(result, temperatures=c(25, 31), SE=c(1, 2), replicate.CI = 10000)
#' d <- c(72, 70, 65, 63, 62, 60, 59)
#' result <- tsd(males=m, females=f, durations=d)
#' predict(result, durations=c(67, 68), replicate.CI = 10000)
#' }
#' @method predict tsd
#' @export


predict.tsd <- function(object, resultmcmc=NULL, chain=1, 
                          replicate.CI=10000, temperatures=NULL, durations=NULL,
                          SD.temperatures= NULL, SD.durations=NULL,
                          probs=c(0.025, 0.5, 0.975), ...) {
  
  # object <- NULL; resultmcmc=NULL; chain=1;replicate.CI=10000; temperatures=NULL; durations=NULL;SD.temperatures= NULL; SD.durations=NULL;probs=c(0.025, 0.5, 0.975)
  
  o <- P_TRT(x=object, resultmcmc=resultmcmc, chain=chain, l=NULL, 
                replicate.CI=replicate.CI, temperatures=temperatures, durations=durations,
                SD.temperatures= SD.temperatures, SD.durations=SD.durations,
                probs=probs)
  
  
return(o$sexratio_quantiles)
}
