\name{envl.plot}
\alias{envl.plot}

\title{Envelope normality plot}
\description{
Constructs a normality plot with total coverage confidence bands with a fixed level.
}
\usage{
 envl.plot(x, conf = 95, plot.it = TRUE, mc = FALSE, k = 10000);
}
\arguments{
  \item{x}{ a numeric vector of data values, if there are missing values, they will be ignored. }
  \item{conf}{ confidence level to be used, it must be a number between 0 and 100. }
  \item{plot.it}{ if TRUE it will draw the corresponding plot, if FALSE it will only return the test values. }
  \item{mc}{ if TRUE a Monte Carlo simulation will be used for the approximation of the critical region, if FALSE the Monte Carlo simulation will be avoided for a confidence of 95\%. }
  \item{k}{ number of observations to use in the Monte Carlo simulation. }
}
\details{
 The function calculates the limits for a quantile-quantile normality plot of the data and its confidence bands, if \code{plot.it} is set to TRUE a plot will be constructed. The null hypothesis is rejected if there is at least one point outside of the confidence bands. For a confidence level of 95\%, p-values are tabulated for some small sample sizes and an approximation is possible for sizes that are not. For other confidence levels the function will calculate the p-values using a Monte Carlo simulation.
}
\value{
 A list with class 'htest' containing the following components:
 \item{quantiles}{the data's quantiles.}
 \item{obs}{data used.}
 \item{low.band}{lower band values of the envelope.}
 \item{high.band}{higher band values of the envelope.}
 \item{method}{the character string 'Envelope test'.}
 \item{data.name}{a character string with the name(s) of the data.}
 \item{alternative}{the character string 'Data was not sampled from a Normal Distribution', the alternative hypothesis.}
 \item{confidence.level}{confidence level used.}
 \item{n}{sample size.}
 \item{criterion}{the character string 'Reject if at least one observed values lies outside of the confidence bands'.}
 \item{outcome}{Logical value if TRUE the null hypothesis is rejected, if FALSE it is not rejected.}
}
\references{W. Rolke, The envelope test, Unpublished manuscript, \url{http://charma.uprm.edu/~rolke/publications.htm}}
\author{ Felipe Acosta }
\note{
 The calculation of the p-values can may take long if \code{k} is large. The minimum recommended value for \code{k} is 5000
}
\seealso{ 
 \code{\link{envl.pval}} for a function to calculate different p-values, \code{\link{qqenvl}} to add confidence bands to a normality plot generated by \code{qqnorm}.
}
\examples{
 envl.plot(rt(30,1))
 envl.plot(rnorm(35,10,4),conf=99)
}
\keyword{ htest }
