% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/network.list.R
\name{network.list}
\alias{network.list}
\alias{network.list.list}
\alias{print.network.list}
\alias{summary.network.list}
\title{A convenience container for a list of \code{\link[network:network]{network}} objects, output
by \code{\link[=simulate.ergm]{simulate.ergm()}} among others.}
\usage{
network.list(object, ...)

\method{print}{network.list}(x, stats.print = FALSE, ...)

\method{summary}{network.list}(
  object,
  stats.print = TRUE,
  net.print = FALSE,
  net.summary = FALSE,
  ...
)
}
\arguments{
\item{object, x}{a \code{list} of networks or a \code{network.list} object.}

\item{...}{for \code{network.list}, additional attributes to be set on
the network list; for others, arguments passed down to
lower-level functions.}

\item{stats.print}{Logical: If TRUE, print network statistics.}

\item{net.print}{Logical: If TRUE, print network overviews.}

\item{net.summary}{Logical: If TRUE, print network summaries.}
}
\description{
A convenience container for a list of \code{\link[network:network]{network}} objects, output
by \code{\link[=simulate.ergm]{simulate.ergm()}} among others.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print(network.list)}: A \code{\link[=print]{print()}} method for network lists.

\item \code{summary(network.list)}: A \code{\link[=summary]{summary()}} method for network lists.

}}
\note{
Functions from the \code{\link[=simulate.ergm]{simulate.ergm()}} family can also return
lists of lists of networks. In this case, they have an additional
class \code{"network.list.list"}. At this time, it only affects
printing.
}
\examples{

# Draw from a Bernoulli model with 16 nodes
# and tie probability 0.1
#
g.use <- network(16, density=0.1, directed=FALSE)
#
# Starting from this network let's draw 3 realizations
# of a model with edges and 2-star terms
#
g.sim <- simulate(~edges+kstar(2), nsim=3, coef=c(-1.8, 0.03),
               basis=g.use, control=control.simulate(
                 MCMC.burnin=100000,
                 MCMC.interval=1000))
print(g.sim)
summary(g.sim)

}
\seealso{
\code{\link[=simulate.ergm]{simulate.ergm()}}
}
