% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeated_twoway_generation.R
\name{twoway_simulation_correlated}
\alias{twoway_simulation_correlated}
\title{Simulate measurements repeated over either or both factors of a two-way design}
\usage{
twoway_simulation_correlated(
  group_size,
  matrices_obj,
  distribution = "normal",
  shape = 0,
  inferior_limit = -Inf,
  superior_limit = Inf,
  balanced = TRUE,
  loss = NULL,
  nsims = 200
)
}
\arguments{
\item{group_size}{Integer or matrix - Sample size for each group (combination of factor levels). If \code{balanced=TRUE} (default) \code{group_size} must be an integer. If \code{balanced=FALSE} \code{group_size} must be a matrix.}

\item{matrices_obj}{List - Output generated by \code{calculate_mean_matrix} that include cell mean and covariance matrices}

\item{distribution}{Character - Type of distribution from which to sample, possible values are "normal", "skewed" and "truncated"}

\item{shape}{Vector - Degree of skewness in the distribution. May be a single value, have a length equal to the number of levels of any one of the factors or a length equal to the product of the length of each factor.}

\item{inferior_limit}{Numeric - Value for which the distribution is truncated on the left. Only valid if \code{distribution="truncated.normal"}}

\item{superior_limit}{Numeric - Value for which the distribution is truncated on the right. Only valid if \code{distribution="truncated.normal"}}

\item{balanced}{Logical - Whether the study will be performed with the same number of subjects in all groups. Default is \code{TRUE}. See 'details'.}

\item{loss}{Character - Type of selection of subjects in groups that have less observations than \code{max(group_size)}. Possible values are 'random' and 'sequential'. Ignored if \code{balanced=TRUE}. See 'details'.}

\item{nsims}{Integer - Number of iterations}
}
\value{
Dataframe with simulated outcome values, factor level labels and iteration number.
}
\description{
Both regular and internal function.
As regular function takes input generated by the \code{calculate_mean_matrix} function and iteratively simulates repeated measures two-way factorial experiments.
Data are sampled from a normal, skewed normal or truncated normal distribution.
}
\details{
As internal function runs with a single iteration inside \code{graph_twoway_assumptions}, which in itself is inside  'calculate_mean_matrix' to generate data for the cell mean and standard deviation plot.

For unbalanced repeated measures designs, this function generates a simulation with \code{max(group_size)} for all combinations of factors and then eliminates observations.
If \code{loss="random"} elimination of in those factor combinations that have less participants or study subjects will occur at random. If \code{loss="sequential"} the participants or subjects
from the groups with less observations will be a subset of participants or subjects of groups with more observations. This may not sound like the most efficient way to proceed, is quite fast anyhow.

The 'n' column in the output will reflect how many observations each factor combination has. This should match the input matrix.
}
\examples{
## Repeated measures design, suppose subjects from 4 independent treatment groups
## measured at 5 different timepoints.

refmean <- 1
treatgroups <- 4
timepoints <- 5
treateff <- 1.5
timeeff <- 0.85
rho <- 0.8
withinf <- "fB"
factors_levels_names <- list(treatment=letters[1:treatgroups], time=1:timepoints)

effects_treat_time <- calculate_mean_matrix(refmean = refmean,
                                            fAeffect = treateff, fBeffect = timeeff,
                                            nlfA = treatgroups,  nlfB = timepoints,
                                            rho = rho, withinf = withinf,
                                            label_list = factors_levels_names)

## Inspect plot to check if matrices correspond to design
effects_treat_time$meansplot

n <- 20
repeatedmeasures_experiment <- twoway_simulation_correlated(group_size = n,
                                matrices_obj = effects_treat_time)

head(repeatedmeasures_experiment, 10)

}
