% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meanlengthofstay.R
\name{meanlengthofstay}
\alias{meanlengthofstay}
\title{Calculate the mean length of stay for a linear facility model}
\usage{
meanlengthofstay(M, init, mgf)
}
\arguments{
\item{M}{A matrix of state transition rates between facility patient states}

\item{init}{A vector of admission state probabilities to each state}

\item{mgf}{The moment generating function characterizing a time-of-stay-dependent removal hazard}
}
\value{
The mean length of stay
}
\description{
Calculate the mean length of stay for a linear facility model
}
\examples{
M <- rbind(c(-1.1,2),c(1,-2.2))
init <- c(0.9,0.1)
mgf <- function(x, deriv=0) MGFgamma(x, rate=0.2, shape=3, deriv)
meanlengthofstay(M, init, mgf)
}
