% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_frequency_analysis.R
\name{compute_frequency_analysis}
\alias{compute_frequency_analysis}
\title{Perform a custom annual frequency analysis}
\usage{
compute_frequency_analysis(
  data,
  events = Year,
  values = Value,
  measures = Measure,
  use_max = FALSE,
  use_log = FALSE,
  prob_plot_position = c("weibull", "median", "hazen"),
  prob_scale_points = c(0.9999, 0.999, 0.99, 0.9, 0.5, 0.2, 0.1, 0.02, 0.01, 0.001,
    1e-04),
  fit_distr = c("PIII", "weibull"),
  fit_distr_method = ifelse(fit_distr == "PIII", "MOM", "MLE"),
  fit_quantiles = c(0.975, 0.99, 0.98, 0.95, 0.9, 0.8, 0.5, 0.2, 0.1, 0.05, 0.01),
  plot_curve = TRUE
)
}
\arguments{
\item{data}{A data frame of flow data that contains columns of events, flow values, and measures (data type).}

\item{events}{Column in \code{data} that contains event identifiers, typically year values. Default \code{"Year"}.}

\item{values}{Column in \code{data} that contains numeric flow values, in units of cubic metres per second. Default \code{"Value"}.}

\item{measures}{Column in \code{data} that contains measure identifiers (example data: '7-day low' or 'Annual Max'). Can have multiple
measures (ex. '7-day low' and '30-day low') in column if multiple statistics are desired. Default \code{"Measure"}.}

\item{use_max}{Logical value to indicate using annual maximums rather than the minimums for analysis. Default \code{FALSE}.}

\item{use_log}{Logical value to indicate log-scale transforming of flow data before analysis. Default \code{FALSE}.}

\item{prob_plot_position}{Character string indicating the plotting positions used in the frequency plots, one of "weibull",
"median", or "hazen". Points are plotted against  (i-a)/(n+1-a-b) where \code{i} is the rank of the value; \code{n} is the 
sample size and \code{a} and \code{b} are defined as: (a=0, b=0) for Weibull plotting positions; (a=.2; b=.3) for Median 
plotting positions; and (a=.5; b=.5) for Hazen plotting positions. Default \code{"weibull"}.}

\item{prob_scale_points}{Numeric vector of probabilities to be plotted along the X axis in the frequency plot. Inverse of 
return period. Default \code{c(.9999, .999, .99, .9, .5, .2, .1, .02, .01, .001, .0001)}.}

\item{fit_distr}{Character string identifying the distribution to fit annual data, one of "PIII" (Pearson Log III distribution) 
or "weibull" (Weibull distribution). Default \code{"PIII"}.}

\item{fit_distr_method}{Character string identifying the method used to fit the distribution, one of  "MOM" (method of moments) 
or "MLE" (maximum likelihood estimation). Selected as \code{"MOM"} if \code{fit_distr}=="PIII" (default) or \code{"MLE"} if 
 \code{fit_distr}=="weibull".}

\item{fit_quantiles}{Numeric vector of quantiles to be estimated from the fitted distribution. 
Default \code{c(.975, .99, .98, .95, .90, .80, .50, .20, .10, .05, .01)}.}

\item{plot_curve}{Logical value to indicate plotting the computed curve on the probability plot. Default \code{TRUE}.}
}
\value{
A list with the following elements:
  \item{Freq_Analysis_Data}{Data frame with computed annual summary statistics used in analysis.}
  \item{Freq_Plot_Data}{Data frame with co-ordinates used in frequency plot.}
  \item{Freq_Plot}{ggplot2 object with frequency plot}
  \item{Freq_Fitting}{List of fitted objects from fitdistrplus.}
  \item{Freq_Fitted_Quantiles}{Data frame with fitted quantiles.}
}
\description{
Performs a flow volume frequency analysis from a streamflow dataset. Defaults to ranking by minimums; 
   use \code{use_max} for to rank by maximum flows. Calculates the statistics from events
   and flow values provided. Columns of events (years), their values (mins or maxs), and identifiers (lowflows, highflows, etc),
   Function will calculate using all values in the provided data (no grouped analysis). Analysis methodology replicates that 
   from \href{http://www.hec.usace.army.mil/software/hec-ssp/}{HEC-SSP}.
}
\examples{
\dontrun{

 # Working example:

# Calculate some values to use for a frequency analysis 
# (requires years, values for those years, and the name of the measure/metric)
low_flows <- calc_annual_lowflows(station_number = "08NM116", 
                                  start_year = 1980, 
                                  end_year = 2000,
                                  roll_days = 7)
low_flows <- dplyr::select(low_flows, Year, Value = Min_7_Day)
low_flows <- dplyr::mutate(low_flows, Measure = "7-Day")

# Compute the frequency analysis using the default parameters
results <- compute_frequency_analysis(data = low_flows,
                                      events = Year,
                                      values = Value,
                                      measure = Measure)
                            
}
}
