% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{EstMGFBetaBin}
\alias{EstMGFBetaBin}
\title{Estimating the shape parameters a and b for Beta-Binomial Distribution}
\usage{
EstMGFBetaBin(x,freq)
}
\arguments{
\item{x}{vector of binomial random variables.}

\item{freq}{vector of frequencies.}
}
\value{
The output of \code{EstMGFBetaBin} will produce the class \code{mgf} format consisting

\code{a} shape parameter of beta distribution representing for alpha

\code{b} shape parameter of beta distribution representing for beta

\code{min} Negative loglikelihood value

\code{AIC} AIC value

\code{call} the inputs for the function

Methods \code{print}, \code{summary}, \code{coef} and \code{AIC} can be used to extract
specific outputs.
}
\description{
The functions will estimate the shape parameters using the maximum log likelihood method and
moment generating function method for the Beta-Binomial distribution when the binomial
random variables and corresponding frequencies are given.
}
\details{
\deqn{a,b > 0}
\deqn{x = 0,1,2,...}
\deqn{freq \ge 0}

\strong{NOTE} : If input parameters are not in given domain conditions necessary error
messages will be provided to go further.
}
\examples{
No.D.D <- 0:7        #assigning the random variables
Obs.fre.1 <- c(47,54,43,40,40,41,39,95)   #assigning the corresponding frequencies

#estimating the parameters using maximum log likelihood value and assigning it
estimate <- EstMLEBetaBin(No.D.D,Obs.fre.1,a=0.1,b=0.1)

bbmle::coef(estimate)   #extracting the parameters

#estimating the parameters using moment generating function methods
results <- EstMGFBetaBin(No.D.D,Obs.fre.1)

# extract the estimated parameters and summary
coef(results)
summary(results)

AIC(results) #show the AIC value

}
\references{
\insertRef{young2008pooling}{fitODBOD}
\insertRef{trenkler1996continuous}{fitODBOD}
\insertRef{hughes1993using}{fitODBOD}
}
\seealso{
\code{\link[bbmle]{mle2}}
}
