% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnostics.R
\name{gof_tests}
\alias{gof_tests}
\title{Goodness of Fit Testing}
\usage{
gof_tests(fits, x)
}
\arguments{
\item{fits}{a list object produced from fit_univariate, fit_empirical, or
fit_univariate_man}

\item{x}{numeric vector of sample data}
}
\value{
a data.frame of test statistic results for each distribution
}
\description{
Apply all goodness of fit tests and return a data.frame with the results
}
\examples{
set.seed(84)
x <- rgamma(100, 1, 1)
dists <- c('gamma', 'lnorm', 'weibull')
multipleFits <- lapply(dists, fit_univariate, x = x)
gof_tests(multipleFits, x)
}
