% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/printers.R
\name{plot.flextable}
\alias{plot.flextable}
\title{Plot a flextable}
\usage{
\method{plot}{flextable}(x, ...)
}
\arguments{
\item{x}{a flextable object}

\item{...}{additional arguments passed to \code{\link[=gen_grob]{gen_grob()}}.}
}
\description{
plots a flextable as a grid grob object
and display the result in a new graphics window.
'ragg' or 'svglite' or 'ggiraph' graphical device drivers
should be used to ensure a correct rendering.
}
\examples{
library(gdtools)
library(ragg)
register_liberationsans()
set_flextable_defaults(font.family = "Liberation Sans")
ftab <- as_flextable(cars)

tf <- tempfile(fileext = ".png")
agg_png(filename = tf, width = 1.7, height = 3.26, unit = "in",
  background = "transparent", res = 150)
plot(ftab)
dev.off()
}
\seealso{
Other flextable print function: 
\code{\link{as_raster}()},
\code{\link{df_printer}()},
\code{\link{flextable_to_rmd}()},
\code{\link{gen_grob}()},
\code{\link{htmltools_value}()},
\code{\link{knit_print.flextable}()},
\code{\link{print.flextable}()},
\code{\link{save_as_docx}()},
\code{\link{save_as_html}()},
\code{\link{save_as_image}()},
\code{\link{save_as_pptx}()},
\code{\link{to_html.flextable}()}
}
\concept{flextable print function}
