% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-classify-grid-rural.R
\name{DoU_classify_grid_rural}
\alias{DoU_classify_grid_rural}
\title{Create the DEGURBA grid cell classification of rural cells}
\usage{
DoU_classify_grid_rural(data, classification, value = 1)
}
\arguments{
\item{data}{path to the directory with the data, or named list with the data as returned by function \code{\link[=DoU_preprocess_grid]{DoU_preprocess_grid()}}}

\item{classification}{SpatRaster. A grid with the classification of urban centres and urban clusters to which the classification of rural cells will be added. Note that the grid will be adapted in-place.}

\item{value}{integer. Value assigned to rural cells in the resulting grid}
}
\value{
SpatRaster with the grid cell classification of rural cells
}
\description{
The Degree of Urbanisation identifies rural cells as all cells not belonging to an urban centre or urban cluster.

For more information about the Degree of Urbanisation methodology, see the \href{https://ec.europa.eu/eurostat/statistics-explained/index.php?title=Applying_the_degree_of_urbanisation_manual}{methodological manual}, \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2022.pdf}{GHSL Data Package 2022} and \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2023.pdf}{GHSL Data Package 2023}.
}
\examples{
data_belgium <- DoU_load_grid_data_belgium()
classification <- DoU_classify_grid_urban_centres(data_belgium)
classification <- DoU_classify_grid_urban_clusters(data_belgium, classification = classification)
classification <- DoU_classify_grid_rural(data_belgium, classification = classification)
DoU_plot_grid(classification)
}
