% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DoU-plot-units.R
\name{DoU_plot_units}
\alias{DoU_plot_units}
\title{Plot the spatial units classification}
\usage{
DoU_plot_units(
  units,
  classification = NULL,
  level1 = TRUE,
  extent = NULL,
  column = NULL,
  palette = NULL,
  labels = NULL,
  title = NULL,
  scalebar = FALSE,
  filename = NULL
)
}
\arguments{
\item{units}{object of class \code{sf}. The spatial units to be displayed on the plot}

\item{classification}{dataframe with the classification of the spatial units, as returned by \code{DoU_classify_units()}. If \code{NULL}, it is assumed that the classification results are merged in the \code{units} object.}

\item{level1}{logical. Whether the spatial units are classified according to level 1 of the Degree of Urbanisation (\code{TRUE}), or level 2 of the Degree of Urbanisation (\code{FALSE}).}

\item{extent}{SpatExtent or an object of class "bbox" (\code{sf}). If not \code{NULL}, the spatial units will be filtered based on the provided extent before plotting.}

\item{column}{character. Column name of the spatial units classification. By default, \code{"flexurba_L1"} when \code{level1=TRUE} and \code{"flexurba_L2"} when \code{level1=FALSE}.}

\item{palette}{named vector with the color palette used to plot the spatial units classification. If \code{NULL}, the standard color palette of the GHSL is used (see \code{GHSL_palette()}).}

\item{labels}{vector with the labels used in the legend. If \code{NULL}, the standard labels of the GHSL are used (see \code{GHSL_labels()}).}

\item{title}{character. Title of the plot.}

\item{scalebar}{logical. Whether to add a scale bar to the plot.}

\item{filename}{character. Path to the location to save the plot}
}
\value{
ggplot object
}
\description{
The function can be used to plot the results of the spatial units classification of the Degree of Urbanisation. The implementation relies upon the function \code{ggplot2::geom_sf()}. By default, the standard color scheme of the Global Human Settlement Layer (GHSL) is used (see \href{https://ghsl.jrc.ec.europa.eu/documents/GHSL_Data_Package_2023.pdf}{GHSL Data Package 2023}), but this can be altered by the \code{palette} argument.

Note that the function is computational quite heavy for large spatial extents (regional or global scale). It is advised to use the \code{extent} argument to plot only a selection of the spatial units classification.
}
\examples{
# get spatial units classification
data_belgium <- DoU_load_grid_data_belgium()
grid_classification <- DoU_classify_grid(data_belgium)
data1 <- DoU_preprocess_units(
  units = flexurba::units_belgium,
  classification = grid_classification,
  pop = data_belgium$pop
)
units_classification <- DoU_classify_units(data1)

# plot using the standard color palette
DoU_plot_units(data1$units, units_classification)

# plot using custom palette and labels
DoU_plot_units(data1$units, units_classification,
  palette = c("3" = "#e16c72", "2" = "#fac66c", "1" = "#97c197"),
  labels = c("C", "T", "R")
)
}
