% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_transect.R
\name{download_transect}
\alias{download_transect}
\title{Download a single floristic quality transect assessment}
\usage{
download_transect(transect_id)
}
\arguments{
\item{transect_id}{A numeric identifier of the desired floristic quality
transect assessment, as specified by
\href{https://universalfqa.org/}{universalfqa.org}. ID numbers for transect
assessments in specified databases can be viewed with the
\code{\link[=index_fqa_transects]{index_fqa_transects()}} function.}
}
\value{
An untidy data frame in the original format of the Universal FQA
  website. Use \code{\link[=transect_glance]{transect_glance()}} for a tidy
  summary, \code{\link[=transect_phys]{transect_phys()}} for a
  physiognometric overview, and
  \code{\link[=transect_inventory]{transect_inventory()}} for species-level
  data.
}
\description{
\code{download_transect()} retrieves a specified floristic quality transect
assessment from \href{https://universalfqa.org/}{universalfqa.org}. ID
numbers for transect assessments in various databases can be found using the
\code{\link[=index_fqa_transects]{index_fqa_transects()}} function.
}
\examples{
\donttest{
databases <- index_fqa_databases() # Database 1 is the original 1994 Chicago edition.
chicago_transects <- index_fqa_transects(1) # CBG Sand prairie swale fen A has id number 5932.
cbg <- download_transect(5932)
}

}
