% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/species_profile_plot.R
\name{species_profile_plot}
\alias{species_profile_plot}
\title{Plot the co-occurrence profile of a species}
\usage{
species_profile_plot(species, inventory_list, native = FALSE)
}
\arguments{
\item{species}{The scientific name of the target plant species}

\item{inventory_list}{A list of site inventories having the format of
\code{\link[=assessment_list_inventory]{assessment_list_inventory()}}}

\item{native}{Logical indicating whether only native co-occurrences should be
considered.}
}
\description{
\code{species_profile_plot()} accepts a species and list of inventories like
those generated by
\code{\link[=assessment_list_inventory]{assessment_list_inventory()}} and
generates a histogram of the co-occurrence profile of that species. Repeated
co-occurrences across multiple assessments are included in summary
calculations but self co-occurrences are not.
}
\examples{
# species_profile_plot() is best used in combination with
# download_assessment_list() and assessment_list_inventory().

\donttest{
ontario <- download_assessment_list(database = 2)
ontario_invs <- assessment_list_inventory(ontario)
species_profile_plot("Aster lateriflorus", ontario_invs, native = TRUE)
}

}
