% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_notes.R
\name{write_notes}
\alias{write_notes}
\title{Create a project README file}
\usage{
write_notes(path = here::here(), .initialize_proj = FALSE)
}
\arguments{
\item{path}{Character string. Path to the project directory.}

\item{.initialize_proj}{Logical. TRUE only if starting a 
\code{froggeR::quarto_project()}.}
}
\value{
CA chronological project progress notes tracker.
}
\description{
This function streamlines project documentation by creating a dated progress notes 
file.
}
\details{
The dated_progress_notes.md file is initialized with the current date and is designed
to help track project milestones chronologically. If the progress notes file already 
exists, the function will stop and warn the user.
}
\examples{
# Create a temporary directory for testing
tmp_dir <- tempdir()

# Write the progress notes file
write_notes(path = tmp_dir)

# Confirm the file was created (optional, for user confirmation)
file.exists(file.path(tmp_dir, "dated_progress_notes.md"))

# Clean up: Remove the created file
unlink(file.path(tmp_dir, "dated_progress_notes.md"))

}
