% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/02_sof_pc.R
\name{sof_pc}
\alias{sof_pc}
\title{Scalar-on-function linear regression based on principal components}
\usage{
sof_pc(
  y,
  mfdobj_x,
  tot_variance_explained = 0.9,
  selection = "variance",
  single_min_variance_explained = 0,
  components = NULL
)
}
\arguments{
\item{y}{A numeric vector containing the observations of the
scalar response variable.}

\item{mfdobj_x}{A multivariate functional data object of class mfd
denoting the functional covariates.}

\item{tot_variance_explained}{The minimum fraction of variance
that has to be explained
by the set of multivariate functional principal components
retained into the MFPCA model
fitted on the functional covariates.
Default is 0.9.}

\item{selection}{A character value with one of three possible values:

if "variance", the first M multivariate functional principal components
are retained into the MFPCA model such
that together they explain a fraction of variance greater
than \code{tot_variance_explained},

if "PRESS", each j-th functional principal component is retained
into the MFPCA model if,
by adding it to the
set of the first j-1 functional principal components,
then the predicted residual error sum of squares (PRESS) statistic decreases,
and at the same time the fraction of variance explained
by that single component
is greater than \code{single_min_variance_explained}.
This criterion is used in Capezza et al. (2020).

if "gcv", the criterion is equal as in the previous "PRESS" case,
but the "PRESS" statistic is substituted by the
generalized cross-validation (GCV) score.

Default value is "variance".}

\item{single_min_variance_explained}{The minimum fraction of variance
that has to be explained
by each multivariate functional principal component into the
MFPCA model fitted
on the functional covariates such that it is retained into the MFPCA model.
Default is 0.}

\item{components}{A vector of integers with the components over which
to project the functional covariates.
If this is not NULL, the criteria to select components are ignored.
If NULL, components are selected according to
the criterion defined by \code{selection}.
Default is NULL.}
}
\value{
a list containing the following arguments:
\itemize{
\item \code{mod}: an object of class \code{lm} that is a linear regression
model where
the scalar response variable is \code{y} and
the covariates are the MFPCA scores of the functional covariates,
\item \code{mod$coefficients} contains the matrix of coefficients of the
functional regression basis functions,
\item \code{pca}: an object of class \code{pca_mfd} obtained by doing MFPCA
on the functional covariates,
\item \code{beta_fd}: an object of class \code{mfd} object containing
the functional regression coefficient
\eqn{\beta(t)} estimated with the
scalar-on-function linear regression model,
\item \code{components}: a vector of integers with the components
selected in the \code{pca} model,
\item \code{selection}: the same as the provided argument
\item \code{single_min_variance_explained}: the same as the provided argument
\item \code{tot_variance_explained}: the same as the provided argument
\item \code{gcv}: a vector whose j-th element is the GCV score obtained
when retaining the first j components
in the MFPCA model.
\item \code{PRESS}: a vector whose j-th element is the PRESS statistic
obtained when retaining the first j components
in the MFPCA model.
}
}
\description{
Scalar-on-function linear regression based on
principal components.
This function performs multivariate functional principal component analysis
(MFPCA)
to extract multivariate functional principal components
from the multivariate functional covariates,
then it builds a linear regression model of a
scalar response variable on the
covariate scores.
Functional covariates are standardized before the regression.
See Capezza et al. (2020) for additional details.
}
\examples{
library(funcharts)
data("air")
air <- lapply(air, function(x) x[1:10, , drop = FALSE])
fun_covariates <- c("CO", "temperature")
mfdobj_x <- get_mfd_list(air[fun_covariates], lambda = 1e-2)
y <- rowMeans(air$NO2)
mod <- sof_pc(y, mfdobj_x)

}
\references{
Capezza C, Lepore A, Menafoglio A, Palumbo B, Vantini S. (2020)
Control charts for
monitoring ship operating conditions and CO2 emissions based
on scalar-on-function regression.
\emph{Applied Stochastic Models in Business and Industry},
36(3):477--500.
\url{doi:10.1002/asmb.2507}
}
\author{
C. Capezza
}
