% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootDom12.R
\name{bootDom12}
\alias{bootDom12}
\title{bootstrap confidence intervals for (x2-x1) exact SD1 to SD4 stochastic dominance 
.}
\usage{
bootDom12(x1, x2, confLevel = 95, reps = 999)
}
\arguments{
\item{x1}{{a vector of n portfolio returns}}

\item{x2}{{a vector of n portfolio returns}}

\item{confLevel}{{confidene level confLevel=95 is default}}

\item{reps}{{number of bootstrap resamples, default is reps=999}}
}
\value{
A matrix with six columns. First two Low1 and Upp1
are confidence interval limits for x1. Next two columns
have analogous limits for x2. The last but first columns entitled
Lowx2mx1 means lower confidence limit for (x2-x1), where m=minus.
The last column entitled
Uppx2mx1  means upper confidence limit for (x2-x1). 

For strong stochastic dominance of x2 over x1
dominance beyond sampling variability, zero should not be inside
the confidence interval in the last two columns.
}
\description{
This calls the meboot package to create J=999 replications of portfolio return
matrices and compute 95\% confidence intervals on x1, x2 and their
difference (x2-x1).  If the interval on (x2-x1) conta.ins zero the choice
between the two can reverse due to sampling variation
}
\seealso{
see \code{\link{exactSdMtx}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY
}
