% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mcsp2.R
\name{mcmcmake}
\alias{mcmcmake}
\title{Convert to an \code{\link[coda]{mcmc}} object}
\usage{
mcmcmake(...)
}
\arguments{
\item{...}{Output(s) from the functions mentioned in the Details.}
}
\value{
An mcmc object.
}
\description{
Convert to an \code{\link[coda]{mcmc}} object.
}
\details{
This function takes as input the one or more output(s) from
function \code{\link{mcsglmm}} or \code{\link{mcstrga}} and
returns an \code{\link[coda]{mcmc}} object or an
\code{\link[coda]{mcmc.list}} object for coda. The function
requires the \code{coda} package to be installed.
The spatial random field components are assigned the names
\code{z_*} where \code{*} is a number beginning at 1. Similarly,
the regressor coefficients are assigned the names \code{beta_*} if
not unique, or simply \code{beta} if there is only one regressor.
The names \code{ssq}, \code{tsq}, \code{phi}, \code{omg}
correspond to the partial sill, measurement error variance,
spatial range, and relative nugget parameters respectively.
}
\examples{
\dontrun{
### Load the data
data(rhizoctonia)
rhiz <- na.omit(rhizoctonia)
rhiz$IR <- rhiz$Infected/rhiz$Total # Incidence rate of the
                              # rhizoctonia disease

### Define the model
corrf <- "spherical"
ssqdf <- 1
ssqsc <- 1
tsqdf <- 1
tsqsc <- 1
betm0 <- 0
betQ0 <- diag(.01, 2, 2)
phiprior <- c(200, 1, 1000, 100) # U(100, 300)
phisc <- 1
omgprior <- c(3, 1, 1000, 0) # U(0, 3)
omgsc <- 1.3
linkp <- 1

## MCMC parameters
Nout <- 100
Nbi <- 0
Nthin <- 1

### Run MCMC
sample <- mcstrga(Yield ~ IR, data = rhiz,
                  atsample = ~ Xcoord + Ycoord, corrf = corrf,
                  Nout = Nout, Nthin = Nthin,
                  Nbi = Nbi, betm0 = betm0, betQ0 = betQ0,
                  ssqdf = ssqdf, ssqsc = ssqsc,
                  tsqdf = tsqdf, tsqsc = tsqsc,
                  phipars = phiprior, omgpars = omgprior,
                  linkp = linkp,
                  phisc = phisc, omgsc = omgsc, test=FALSE)

mcsample <- mcmcmake(sample)
plot(mcsample[, c("phi", "omg", "beta_1", "beta_2", "ssq", "tsq")],
     density = FALSE)
summary(mcsample[, c("phi", "omg", "beta_1", "beta_2", "ssq", "tsq")])
}
}
\seealso{
Functions such as \code{\link[coda]{plot.mcmc}} and
\code{\link[coda]{summary.mcmc}} in the \code{coda} package. The
function \code{\link[base]{do.call}} can be used to pass arguments
stored in a list.
}

