#' Function to prepare metadata of the main laws for automatic insertion into scientific articles
#'
#' The jur_bib function prepares the metadata of laws to be automatically included in a scientific article. The jur_bib function internally calls two support functions. The output of the jur_bib function is the file with the .bib extension, of the laws in BibTex format, prepared to be automatically included in the reference list of a scientific article.
#'
#' @param input_date is a dataframe with the scientific production database in the form of a laws
#' @param input_tam is the length of the dataframe with the main scientifics articles, obtained using package bibliorefer.
#' @return The output of the jur_bib function is the file with the .bib extension, of the laws in BibTex format, prepared to be automatically included in the reference list of a scientific article.
#' @importFrom utils read.csv2
#' @importFrom bibliorefer principal_lister
#' @export
#'
#' @references
#' 1 - Aria, M. & Cuccurullo, C. (2017) bibliometrix: An R-tool for comprehensive science mapping analysis, Journal of Informetrics, 11(4), pp 959-975, Elsevier.
#' 2 - Bibliometric indicators to evaluate scientific activity. C García-Villar, J M García-Santos. Radiologia (Engl Ed). 2021 May-Jun;63(3):228-235.
#'
#'
#' @examples
#'
#' # Example
#'
#' # File of database
#' file_db <- system.file("extdata","leisemdou.csv", package = "gerefer")
#' separator <- ";"
#'
#' # Parameters of the function
#' input_date <- example_database(file_db, separator)
#' input_tam <- 3
#'
#' #Calls the function bookcap_bib
#' jurlister_bibtex <- jur_bib(input_date, input_tam)
#' jurlister_bibtex
#'
#'
#'
jur_bib <- function(input_date,input_tam){

# Data entry
input_date <- input_date
input_tam <- input_tam

# Call the function that generates the intermediate information
gerad_jur <- function(input_date){

  # Replace dataframe with matrix
  input_entrada <- as.matrix(input_date)

  # Delete NA
  na_retir <- function(input_entr){

    # Data entry
    entrada_base <- input_entr
    entrada_base <- as.data.frame(entrada_base)
    colnames(entrada_base) <- "base"

    # Delete NA
    variavel <- entrada_base$base
    testena <- is.na(variavel)
    padrao <- "TRUE"
    linha_na <- grep(padrao,testena)
    variavel[linha_na] <- ""

    return(variavel)

  }

  # Create the loop indexer
  nomes_colunas <- names(input_date)

  # Create the loop along the columns
  for (i in seq_along(nomes_colunas)){

    input_entr <- nomes_colunas[i]
    names(input_entrada) <- colnames(input_date)
    coluna <- na_retir(input_entrada[,input_entr])
    input_entrada[,i] <- coluna

  }

  # Change format from matrix to dataframe
  tabela <- input_entrada
  tabela <- as.data.frame(input_entrada)
  ##

  # Create the extra table
  n <- length(tabela$autor)
  citacoes <- 1:n
  link <- rep("",n)
  abstract <- rep("",n)
  paginas <- rep("",n)
  volume <- rep("",n)
  extra <- cbind(volume,link,abstract,citacoes)
  extra <- as.data.frame(extra)

  # Create the input table and change the names
  nomes <- c("AU","TI", "edicao", "local", "SO", "PY", "PP",
             "VL","DI","AB","TC")
  baseentrada <- cbind(tabela, extra)
  colnames(baseentrada) <- nomes

  # Call the main list function
  input_dateprin <- baseentrada
  input_tam <- n
  listaprincipal <- principal_lister(input_dateprin,input_tam)
  lista_prin <- listaprincipal[[1]]
  posicao_book <- lista_prin$Article
  posicao_info <- which(posicao_book != "")
  ##

  # Calculating the size of tables
  tamanho <- length(posicao_info)

  # Create the input table and change the name
  tabela_lei <- tabela
  nomes_tabela <- c("autor", "titulo", "ementa", "jornal", "endereco",
                    "compender", "data_lei", "ano_lei", "url", "acesso")
  colnames(tabela_lei) <- nomes_tabela
  ###

  # Call the access date function
  acesso_datas <- function(input_dateace){

    # Remove NA
    na_retir <- function(input_entr){

      # Data entry
      entrada_base <- input_entr
      entrada_base <- as.data.frame(entrada_base)
      colnames(entrada_base) <- "base"

      # Remove NA
      variavel <- entrada_base$base
      testena <- is.na(variavel)
      padrao <- "TRUE"
      linha_na <- grep(padrao,testena)
      variavel[linha_na] <- ""

      return(variavel)

    }

    # Call function to remove NA
    input_entr <- input_dateace
    entrada_data <- na_retir(input_entr)

    # Calculate the column size and generate the corresponding vectors
    n <- length(entrada_data)
    data_acessos <- numeric(n)
    dia_acesso <- numeric(n)

    # Create the loop
    for(i in 1:n){

      if(entrada_data[i] == ""){

        dia_acess <- ""

      }else{

        data_sepa <- strsplit(entrada_data, split = "/")
        data_separ <- data_sepa[[i]]

        # Create the day
        ind_dia <- 1
        dia_separ <- data_separ[ind_dia]

        # Create the month
        ind_mes <- 2
        mes_separ <- data_separ[ind_mes]

        # Create the year
        ind_ano <- 3
        ano_sepa <- data_separ[ind_ano]
        inicio_ano <- 20
        ano_separ <- paste0(inicio_ano,ano_sepa)
        ano_separ <- as.numeric(ano_separ)

        # Generate the access date
        hifen <- "\u002D"
        data_acesso <- paste0(ano_separ, hifen, mes_separ, hifen, dia_separ)
        data_acessos[i] <- data_acesso

        dia_acess <- data_acessos[i]

      }

      dia_acesso[i] <- dia_acess

    }

    return(dia_acesso)

  }

  # Data access function input
  input_dateace <- tabela_lei$acesso
  dia_acesso <- acesso_datas(input_dateace)
  ##

  # Create the legislation title
  tamanho_titul <- tamanho
  tamanho_subti <- numeric(tamanho_titul)
  titul_artic <- numeric(tamanho_titul)
  subtitul_artic <- numeric(tamanho_titul)

  # Call the function from the authors name
  titulo_minu <- function(enti_artic){

    # Data entry
    tit_arti <- enti_artic

    # Change the letter to lowercase
    titu_minu <- tolower(tit_arti)

    # Separate words
    let_minu <- strsplit(titu_minu," ")

    # Select first letter of words
    prl_min <- let_minu[[1]][1]

    # Separate letter from the first word
    prl_minsep <- strsplit(prl_min, "")

    # Select the first lowercase letter
    prl_minu <- prl_minsep[[1]][1]

    #"‘"=2018
    padrao_aspa1 <- "\u2018"
    test_aspa1 <- grepl(padrao_aspa1, prl_minu)

    #"“"=201C
    padrao_aspa2 <- "\u201C"
    test_aspa2 <- grepl(padrao_aspa2, prl_minu)

    #"'"=0027
    padrao_aspavert1 <- "\u0027"
    test_aspavert1 <- grepl(padrao_aspavert1, prl_minu)

    #"`"=0060
    padrao_apost1 <- "\u0060"
    test_apost1 <- grepl(padrao_apost1, prl_minu)

    #"\""="\0022"
    padrao_apost2 <- "\u0022"
    test_apost2 <- grepl(padrao_apost2, prl_minu)

    #"\\("=0028
    padrao_paren <- "\\u0028"
    test_paren <- grepl(padrao_paren, prl_minu)

    #"#"=0023
    padrao_hash <- "\u0023"
    test_hash <- grepl(padrao_hash, prl_minu)


    if(test_aspa1 == TRUE){

      prl_minu <- prl_minsep[[1]][2]

    }else if(test_aspa2 == TRUE){

      prl_minu <- prl_minsep[[1]][2]

    }else if(test_apost1 == TRUE){

      prl_minu <- prl_minsep[[1]][2]

    }else if(test_apost2 == TRUE){

      prl_minu <- prl_minsep[[1]][2]

    }else if(test_aspavert1 == TRUE){

      prl_minu <- prl_minsep[[1]][2]

    }else if(test_paren == TRUE){

      prl_minu <- prl_minsep[[1]][2]

    }else if(test_hash == TRUE){

      prl_minu <- prl_minsep[[1]][2]

    }else{

      prl_minu <- prl_minsep[[1]][1]

    }

    # Capitalize the first letter
    prl_maiu <- toupper(prl_minu)

    # Replace the lowercase letter with the uppercase letter
    tit_artic <- sub(prl_minu,prl_maiu,titu_minu)

    # Return the author's name
    return(tit_artic)

  }

  entitu_artic <- tabela_lei$titulo

  for(i in 1:tamanho){

    enti_artic <- entitu_artic[i]

    # Return the author's name
    padrao_pont <- ": "
    padrao_pont1 <- ":"
    test_subtitu <- grepl(padrao_pont,enti_artic)

    padrao_true <- "TRUE"
    linha_sub <- grep(padrao_true,test_subtitu)
    tamanho_titul <- length(linha_sub)

    # Standardize the page separator
    if(test_subtitu == FALSE){

      titu_artic <- enti_artic
      titu_artic <- titulo_minu(titu_artic)
      subtitu_artic <- ""

    }else{

      titulo_basesepar <- strsplit(enti_artic,
                                   split = padrao_pont)
      comp_subti <- length(titulo_basesepar[[1]])

      if(comp_subti == 2){

        titu_artic <- paste0(titulo_basesepar[[1]][1],padrao_pont1)
        titu_artic <- titulo_minu(titu_artic)
        subtitu_artic <- titulo_basesepar[[1]][2]
        subtitu_artic <- tolower(subtitu_artic)

      }else{

        titu_artic <- paste0(titulo_basesepar[[1]][1],padrao_pont1)
        titu_artic <- titulo_minu(titu_artic)
        subtitu_artic <- titulo_basesepar[[1]][2]

        for(k in 3:comp_subti){

          subtitu_artic <- paste0(subtitu_artic, sep = ".",
                                  titulo_basesepar[[1]][k])
          subtitu_artic <- tolower(subtitu_artic)
        }

      }

    }

    titul_artic[i] <- titu_artic
    subtitul_artic[i] <- subtitu_artic

  }
  ##
  # Create the year author identity
  # Separate team authors
  autsep_article <- strsplit(tabela_lei$autor, split = " ")

  autor <- numeric(tamanho)
  autor_ano <- numeric(tamanho)
  autores <- numeric(tamanho)

  for(i in 1:tamanho){

    tama_autor <- length(autsep_article[[i]])

    if(tama_autor == 1){

      autoria <- autsep_article[[i]][1]

    }else{

      autoria <- autsep_article[[i]][1]

    }

    autor[i] <- autoria
    autor_ano[i] <- paste0(autor[i],tabela_lei$ano_lei[i])

  }
  ##

  organi_nome <- function(input_nom){

    # Data entry
    input_date <- input_nom
    input_date <- as.data.frame(input_date)
    colnames(input_date) <- "nomess"

    # Call the function from the authors name
    minu_autor <- function(eq_autor){

      # Data entry
      nom_autsep <- eq_autor

      # Change the letter to lowercase
      autor_minu <- tolower(nom_autsep)

      # Separate words
      let_minu <- strsplit(autor_minu,"")

      # Select first letter of words
      prl_minu <- let_minu[[1]][1]

      # Capitalize the first letter
      prl_maiu <- toupper(prl_minu)

      # Replace the lowercase letter with the uppercase letter
      autor <- sub(prl_minu,prl_maiu,autor_minu)

      # Return the author's name
      return(autor)

    }
    ##

    # Create the place names
    nome_maius <- toupper(input_date$nomess)
    n <- length(nome_maius)
    nome_local <- numeric(n)

    for(i in 1:n){

      padr_prepmai <- c("DA", "DE", "DO", "DAS", "DOS")
      padr_prepmin <- c("da", "de", "do", "das", "dos")
      padr_hif <- "\u002D"
      padr_esp <- " "
      teste_hifen <- grepl(padr_hif,nome_maius[i])

      if(teste_hifen == TRUE){

        nomeorg_sepa <- strsplit(nome_maius[i], split = padr_hif)
        tam_norg <- length(nomeorg_sepa[[1]])
        nomeorg_separ <- numeric(tam_norg)

        for(k in 1:tam_norg){

          nomeorg_sepa <- strsplit(nome_maius[i], split = padr_hif)
          nomeorg_separa <- nomeorg_sepa[[1]][k]
          nomeorg_separa <- minu_autor(nomeorg_separa)
          nomeorg_separ[k] <- nomeorg_separa
        }

        if(tam_norg == 2){

          nome_org <- paste0(nomeorg_separ[1],padr_hif,nomeorg_separ[2])

        }else{

          nome_org <- numeric(tam_norg)
          nome_org[1] <- nomeorg_separ[1]

          for(k in 2:tam_norg-1){

            nome_org[k] <- paste0(nome_org[k-1],nomeorg_separ[k],padr_hif)
          }
          nome_org[tam_norg] <- nomeorg_separ[tam_norg]
          nome_org <- paste0(nome_org[tam_norg-1],nomeorg_separ[tam_norg])
        }

      }else{

        nomeorg_sepa <- strsplit(nome_maius[i], split = padr_esp)
        nomeorg_separ <- nomeorg_sepa[[1]]
        tam_norg <- length(nomeorg_separ)

        for(k in 1:tam_norg){

          if(nomeorg_separ[k] == padr_prepmai[1]){

            nomeorg_separ[k] <- padr_prepmin[1]

          }else if(nomeorg_separ[k] == padr_prepmai[2]){

            nomeorg_separ[k] <- padr_prepmin[2]

          }else if(nomeorg_separ[k] == padr_prepmai[3]){

            nomeorg_separ[k] <- padr_prepmin[3]

          }else if(nomeorg_separ[k] == padr_prepmai[4]){

            nomeorg_separ[k] <- padr_prepmin[4]

          }else if(nomeorg_separ[k] == padr_prepmai[5]){

            nomeorg_separ[k] <- padr_prepmin[5]

          }else{

            nomeorg_separ[k] <- minu_autor(nomeorg_separ[k])

          }

        }
        ####
        if(tam_norg == 2){

          nome_org <- paste0(nomeorg_separ[1],padr_esp,nomeorg_separ[2])

        }else{

          nome_org <- numeric(tam_norg)
          nome_org[1] <- nomeorg_separ[1]

          for(k in 2:tam_norg-1){

            nome_org[k] <- paste0(nome_org[k-1],nomeorg_separ[k],padr_esp)
          }
          nome_org[tam_norg] <- nomeorg_separ[tam_norg]
          nome_org <- paste0(nome_org[tam_norg-1],nomeorg_separ[tam_norg])
        }

      }

      nome_local[i] <- nome_org
    }

    nome_local <- as.data.frame(nome_local)
    padrao <- "Brasilia, Df"
    linha_bra <- grep(padrao, nome_local$nome_local)
    nome_distri <- "Brasilia, DF"
    nome_local[linha_bra,] <- nome_distri

    return(nome_local)

  }

  # Call the function from the location names
  input_nom <- tabela_lei$endereco
  endereco <- organi_nome(input_nom)

  # Remove NA
  na_retir <- function(input_entr){

    # Data entry
    entrada_base <- input_entr
    entrada_base <- as.data.frame(entrada_base)
    colnames(entrada_base) <- "base"

    # Remove NA
    variavel <- entrada_base$base
    testena <- is.na(variavel)
    padrao <- "TRUE"
    linha_na <- grep(padrao,testena)
    variavel[linha_na] <- ""

    return(variavel)

  }

  autores <- tabela_lei$autor
  autores <- toupper(autores)

  ementa <- tabela_lei$ementa
  jornal <- tabela_lei$jornal
  data_lei <- tabela_lei$data_lei
  links <- tabela_lei$url
  endereco <- tabela_lei$endereco
  ano_lei <- tabela_lei$ano_lei
  compende <- tabela_lei$compender
  compende <- na_retir(compende)

  dados_pub <- numeric(tamanho)

  for(i in 1:tamanho){

    dois_pon <- ":"
    espaco <- " "
    virg <- ","

    if(compende[i] == ""){

      virgc <- ""
      espacoc <- ""
      nota <- paste0(endereco[i], dois_pon, espaco, compende[i], virgc,
                     espacoc,ano_lei[i])

    }else{

      nota <- paste0(endereco[i], dois_pon, espaco, compende[i], virg,
                     espaco, ano_lei[i])
    }

    dados_pub[i] <- nota
  }

  # Create access dates
  datasacessos <- dia_acesso

  # Create the table with the information of interest and change the format
  tabel_bibtexi <- cbind(autor_ano, autores, titul_artic, ementa,
                         dados_pub, links, datasacessos)
  tabel_bibtexi <- as.data.frame(tabel_bibtexi)

  # Change column names
  nomes <- c("fonte_ano","autores","titulo","ementa",
             "dado_public","links","dataacesso")
  colnames(tabel_bibtexi) <- nomes

  # Create the list
  tabela_bibtex <- list()
  tabela_bibtex <- list(tabel_bibtexi, tamanho)
  names(tabela_bibtex) <- c("tabel_bibtex", "tamanho")

  # Return the information
  return(tabela_bibtex)

}

#Call the gerard_dissert function
tabel_bibte <- gerad_jur(input_date)
# Create the variables of interest
tabel_bibtex <- tabel_bibte[[1]]
tamanho <- tabel_bibte[[2]]

# Function that generates the file in bibtex format
bibtex_lister <- function(tabel_bibtex,indic){

  # Data entry
  input_tabel <- tabel_bibtex
  tabela <- input_tabel
  linha <- indic

  # Reduce database size
  tabela_redu <- tabela[linha,]
  tabela_ent <- tabela_redu

  # Assign input information to variables
  simbolo_entrada <- "@misc{"
  fonte_ano <- tabela_ent$fonte_ano
  autor <- tabela_ent$autores
  titulo <- tabela_ent$titulo
  ementa <- tabela_ent$ementa
  dados_pub <- tabela_ent$dado_public
  link <- tabela_ent$links
  acesso <- tabela_ent$dataacesso

  # Create the elements of the bibtex format structure
  espaco <- "  "
  virgula <- ","
  autorarticle <- "author="
  tituloarticle <- "title="
  ementaarticle <- "howpublished="
  dados_pubarticle <- "note="
  linkarticle <- "url="
  acessoarticle <- "urldate="

  #publicacaoart <- "publisher="
  chave_entrada <- "{"
  chave_saida <- "}"

  # Create the bibtex structure for each variable
  chave <- paste0(simbolo_entrada,fonte_ano,virgula)
  autor <- paste0(autorarticle,chave_entrada,chave_entrada,autor,
                  chave_saida,chave_saida)
  titulo <- paste0(tituloarticle,chave_entrada,titulo,
                   chave_saida)
  ementa <- paste0(ementaarticle,chave_entrada,ementa,
                   chave_saida)
  dados_pub <- paste0(dados_pubarticle,chave_entrada,dados_pub,
                      chave_saida)
  link <- paste0(linkarticle,chave_entrada,link,
                 chave_saida)
  acesso <- paste0(acessoarticle,chave_entrada,acesso,
                   chave_saida)

  # Create bibtex format for articles
  referen_bibtex <- paste0(chave,"\n",
                           espaco, autor, virgula, "\n",
                           espaco, titulo, virgula, "\n",
                           espaco, ementa, virgula, "\n",
                           espaco, dados_pub, virgula, "\n",
                           espaco, link, virgula, "\n",
                           espaco, acesso, "\n", chave_saida,
                           espaco, collapse = ",\n")

  # Returns the file in bibtex format
  return(referen_bibtex)
}

arquivo_bibtex <- c()

# Create the loop to generate the list of bibtex files
for(i in 1:tamanho){

  # Create the parameter linked to the index
  indic <- i

  # Call the function that converts to bibtex format
  refer_bibtex <- bibtex_lister(tabel_bibtex,indic)
  arquivo_bibtex[i] <- refer_bibtex

}

# Return the value of the variable
lista_final <- arquivo_bibtex

return(lista_final)

}
