% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GermSynchrony.R
\name{GermSynchrony}
\alias{GermSynchrony}
\alias{GermUncertainty}
\title{Synchrony and uncertainty of germination}
\usage{
GermSynchrony(germ.counts, intervals, partial = TRUE)

GermUncertainty(germ.counts, intervals, partial = TRUE)
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}
}
\value{
For \code{GermUncertainty}, the value of uncertainty of germination
  process in \mjseqn{\mathrm{bit}}.

  For \code{GermSynchrony}, the value of synchrony of germination.
}
\description{
Compute the following metrics:\describe{ \item{\code{GermSynchrony}}{
Synchrony of germination (\mjseqn{Z} index)
\insertCite{primack_longevity_1985,ranal_how_2006}{germinationmetrics}. }
\item{\code{GermUncertainty}}{Synchronization index (\mjseqn{\overline{E}})
or Uncertainty of the germination process (\mjseqn{U}) or Informational
entropy (\mjseqn{H})
\insertCite{shannon_mathematical_1948,labouriau_germination_1976,labouriau_uma_1983}{germinationmetrics}.}
} \loadmathjax
}
\details{
\code{GermSynchrony} computes the value of synchrony of germination
(\mjseqn{Z} index) as follows
\insertCite{primack_longevity_1985,ranal_how_2006}{germinationmetrics}.

\mjsdeqn{Z=\frac{\sum_{i=1}^{k}C_{N_{i},2}}{C_{\Sigma N_{i},2}}}

Where, \mjseqn{C_{N_{i},2}} is the partial combination of the two germinated
seeds from among \mjseqn{N_{i}}, the number of seeds germinated on the
\mjseqn{i}th time interval (estimated as
\mjseqn{C_{N_{i},2}=\frac{N_{i}(N_{i}-1)}{2}}), and \mjseqn{C_{\Sigma
N_{i},2}} is the partial combination of the two germinated seeds from among
the total number of seeds germinated at the final count, assuming that all
seeds that germinated did so simultaneously.

\code{GermUncertainty} computes the value of synchronization index
(\mjseqn{\overline{E}}) or uncertainty of the germination process
(\mjseqn{U}) or informational entropy (\mjseqn{H}) as follows
\insertCite{shannon_mathematical_1948,labouriau_germination_1976,labouriau_uma_1983}{germinationmetrics}.

\mjsdeqn{\overline{E} = -\sum_{i=1}^{k}f_{i}\log_{2}f_{i}}

Where, \mjseqn{f_{i}} is the relative frequency of germination (estimated as
\mjseqn{f_{i}=\frac{N_{i}}{\sum_{i=1}^{k}N_{i}}}), \mjseqn{N_{i}} is the
number of seeds germinated on the \mjseqn{i}th time interval, and \mjseqn{k}
is the total number of time intervals.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
GermSynchrony(germ.counts = x, intervals = int)
GermUncertainty(germ.counts = x, intervals = int)

# From cumulative germination counts
#----------------------------------------------------------------------------
GermSynchrony(germ.counts = y, intervals = int, partial = FALSE)
GermUncertainty(germ.counts = y, intervals = int, partial = FALSE)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[germinationmetrics]{CUGerm}}
}
