% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme.R
\name{complete_theme}
\alias{complete_theme}
\title{Complete a theme}
\usage{
complete_theme(theme = NULL, default = theme_get())
}
\arguments{
\item{theme}{An incomplete \link[=theme]{theme} object to complete, or \code{NULL}
to complete the default theme.}

\item{default}{A complete \link[=theme]{theme} to fill in missing pieces.
Defaults to the global theme settings.}
}
\value{
A \link[=theme]{theme} object.
}
\description{
This function takes a theme and completes it so that it can be used
downstream to render theme elements. Missing elements are filled in and
every item is validated to the specifications of the element tree.
}
\examples{
my_theme <- theme(line = element_line(colour = "red"))
complete_theme(my_theme)
}
\keyword{internal}
