% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-sideboxplot.r
\name{geom_xsideboxplot}
\alias{geom_xsideboxplot}
\alias{geom_*sideboxplot}
\alias{geom_ysideboxplot}
\title{Side boxplots}
\usage{
geom_xsideboxplot(
  mapping = NULL,
  data = NULL,
  stat = "boxplot",
  position = "dodge2",
  ...,
  outlier.colour = NULL,
  outlier.color = NULL,
  outlier.fill = NULL,
  outlier.shape = 19,
  outlier.size = 1.5,
  outlier.stroke = 0.5,
  outlier.alpha = NULL,
  notch = FALSE,
  notchwidth = 0.5,
  varwidth = FALSE,
  na.rm = FALSE,
  orientation = "x",
  show.legend = NA,
  inherit.aes = TRUE
)

geom_ysideboxplot(
  mapping = NULL,
  data = NULL,
  stat = "boxplot",
  position = "dodge2",
  ...,
  outlier.colour = NULL,
  outlier.color = NULL,
  outlier.fill = NULL,
  outlier.shape = 19,
  outlier.size = 1.5,
  outlier.stroke = 0.5,
  outlier.alpha = NULL,
  notch = FALSE,
  notchwidth = 0.5,
  varwidth = FALSE,
  na.rm = FALSE,
  orientation = "y",
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}} or
\code{\link[ggplot2:aes_]{aes_()}}. If specified and \code{inherit.aes = TRUE} (the
default), it is combined with the default mapping at the top level of the
plot. You must supply \code{mapping} if there is no plot mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{Use to override the default connection between
\code{geom_boxplot()} and \code{stat_boxplot()}.}

\item{position}{Position adjustment, either as a string, or the result of
a call to a position adjustment function.}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{outlier.colour}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.color}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.fill}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.shape}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.size}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.stroke}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{outlier.alpha}{Default aesthetics for outliers. Set to \code{NULL} to inherit from the
aesthetics used for the box.

In the unlikely event you specify both US and UK spellings of colour, the
US spelling will take precedence.

Sometimes it can be useful to hide the outliers, for example when overlaying
the raw data points on top of the boxplot. Hiding the outliers can be achieved
by setting \code{outlier.shape = NA}. Importantly, this does not remove the outliers,
it only hides them, so the range calculated for the y-axis will be the
same with outliers shown and outliers hidden.}

\item{notch}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, make a notched box plot. Notches are used to compare groups;
if the notches of two boxes do not overlap, this suggests that the medians
are significantly different.}

\item{notchwidth}{For a notched box plot, width of the notch relative to
the body (defaults to \code{notchwidth = 0.5}).}

\item{varwidth}{If \code{FALSE} (default) make a standard box plot. If
\code{TRUE}, boxes are drawn with widths proportional to the
square-roots of the number of observations in the groups (possibly
weighted, using the \code{weight} aesthetic).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{orientation}{The orientation of the layer. The default (\code{NA})
automatically determines the orientation from the aesthetic mapping. In the
rare event that this fails it can be given explicitly by setting \code{orientation}
to either \code{"x"} or \code{"y"}. See the \emph{Orientation} section for more detail.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
XLayer or YLayer object to be added to a ggplot object
}
\description{
The \link{xside} and \link{yside} variants of \link[ggplot2]{geom_boxplot}
is \link{geom_xsideboxplot} and \link{geom_ysideboxplot}.
}
\examples{

df <- expand.grid(UpperCase = LETTERS, LowerCase = letters)
df$Combo_Index <- as.integer(df$UpperCase)*as.integer(df$LowerCase)

p1 <- ggplot(df, aes(UpperCase, LowerCase)) +
geom_tile(aes(fill = Combo_Index))

#sideboxplots
#Note - Mixing discrete and continuous axis scales
#using xsideboxplots when the y aesthetic was previously
#mapped with a continuous varialbe will prevent
#any labels from being plotted. This is a feature that
#will hopefully be added to ggside in the future.

p1 + geom_xsideboxplot(aes(y = Combo_Index)) +
   geom_ysideboxplot(aes(x = Combo_Index))

#sideboxplots with swapped orientation
#Note - Discrete before Continuous
#If you are to mix Discrete and Continuous variables on
#one axis, ggplot2 prefers the discrete variable to be mapped
#BEFORE the continuous.
ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species)) +
    geom_xsideboxplot(aes(y = Species), orientation = "y") +
    geom_point()

#Alternatively, you can recast discrete as a factor and then
#a numeric
ggplot(iris, aes(Sepal.Width, Sepal.Length, color = Species))+
  geom_point() +
  geom_xsideboxplot(aes(y = as.numeric(Species)), orientation = "y") +
  geom_ysideboxplot(aes(x = as.numeric(Species)), orientation = "x")

}
\seealso{
\link{geom_*sideviolin}
}
