% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grandR.R
\name{check.analysis}
\alias{check.analysis}
\alias{check.slot}
\alias{check.mode.slot}
\title{Internal functions to check for a valid analysis or slot names.}
\usage{
check.analysis(data, analyses, regex)

check.slot(data, slot, allow.ntr = TRUE)

check.mode.slot(data, mode.slot, allow.ntr = TRUE)
}
\arguments{
\item{data}{a grandR object}

\item{analyses}{a regex to be matched to analysis names}

\item{regex}{interpret as regular expression}

\item{slot}{a slot name}

\item{allow.ntr}{whether to allow for the value "ntr" (and throw an error in case)}

\item{mode.slot}{a mode.slot}
}
\value{
Whether or not the given name is valid and unique for the grandR object
}
\description{
Internal functions to check for a valid analysis or slot names.
}
\details{
A mode.slot is a mode followed by a dot followed by a slot name, or just a slot name. A mode is either \emph{total}, \emph{new} or \emph{old}.
}
\concept{helper}
