% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/differs_from_previous.R
\name{differs_from_previous}
\alias{differs_from_previous}
\alias{not_previous}
\title{Find values in a vector that differ from the previous value.}
\usage{
differs_from_previous(data, col = NULL, threshold = NULL,
  direction = "both", return_index = FALSE, include_first = FALSE,
  factor_conversion_warning = TRUE)
}
\arguments{
\item{data}{Data frame or Vector

N.B. If checking a factor, it is converted to a character vector.
This means that factors can only be used when \code{threshold} is \code{NULL}.
Conversion will generate a warning, which can be turned off by setting \code{factor_conversion_warning} to \code{FALSE}.}

\item{col}{Name of column to find values that differ in. Used when data is
data frame. (Character)}

\item{threshold}{Threshold to check difference to previous value to.

 \code{NULL}, numerical scalar or numerical vector with length 2.

 \subsection{NULL}{
 Checks if the value is different from the previous value.

 Ignores \code{direction}.

 N.B. Works for both numerical and character vectors.
 }
 \subsection{Numerical scalar}{
 Positive number.

 Negative threshold is the negated number.

 N.B. Only works for numerical vectors.
 }
 \subsection{Numerical vector with length 2}{
 Given as \code{c(negative threshold, positive threshold)}.

 Negative threshold must be a negative number and positive threshold must be a positive number.

 N.B. Only works for numerical vectors.
 }}

\item{direction}{\code{both}, \code{positive} or \code{negative}. (character)
\subsection{both}{
Checks whether the difference to the previous value is
  \itemize{
    \item greater than or equal to the positive threshold.
    \item less than or equal to the negative threshold.
  }
}
\subsection{positive}{
Checks whether the difference to the previous value is
  \itemize{
    \item greater than or equal to the positive threshold.
  }
}
\subsection{negative}{
Checks whether the difference to the previous value is
  \itemize{
    \item less than or equal to the negative threshold.
  }
}}

\item{return_index}{Return indices of values that differ. (Logical)}

\item{include_first}{Whether to include first element in vector in output. (Logical)}

\item{factor_conversion_warning}{Generate warning when converting factor to character. (Logical)}
}
\value{
Vector with either differing values or indices of differing values.
}
\description{
Finds values, or indices of values, that differ from the previous value by some threshold(s).

 Operates with both a positive and a negative threshold.
 Depending on \code{direction}, it checks if the difference to the previous value is:
 \itemize{
   \item greater than or equal to the positive threshold.
   \item less than or equal to the negative threshold.
 }
}
\examples{
# Attach packages
library(groupdata2)

# Create a data frame
df <- data.frame('a' = c('a','a','b','b','c','c'),
                 'n' = c(1,3,6,2,2,4))

# Get differing values in column 'a' with no threshold.
# This will simply check, if it is different to the previous value or not.
differs_from_previous(df, col = 'a')

# Get indices of differing values in column 'a' with no threshold.
differs_from_previous(df, col = 'a', return_index = TRUE)

# Get values, that are 2 or more greater than the previous value
differs_from_previous(df, col = 'n', threshold=2, direction="positive")

# Get values, that are 4 or more less than the previous value
differs_from_previous(df, col = 'n', threshold=4, direction="negative")

# Get values, that are either 2 or more greater than the previous value
# or 4 or more less than the previous value
differs_from_previous(df, col = 'n', threshold=c(-4,2), direction="both")
}
\seealso{
Other l_starts tools: \code{\link{find_missing_starts}},
  \code{\link{find_starts}}, \code{\link{group_factor}},
  \code{\link{group}}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{l_starts tools}
