% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{as_rtf}
\alias{as_rtf}
\title{Output a \strong{gt} object as RTF}
\usage{
as_rtf(
  data,
  incl_open = TRUE,
  incl_header = TRUE,
  incl_page_info = TRUE,
  incl_body = TRUE,
  incl_close = TRUE
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{incl_open, incl_close}{\emph{Include opening/closing braces}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

Options that govern whether the opening or closing \code{"{"} and \code{"}"} should
be included. By default, both options are \code{TRUE}.}

\item{incl_header}{\emph{Include RTF header}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

Should the RTF header be included in the output? By default, this is
\code{TRUE}.}

\item{incl_page_info}{\emph{Include RTF page information}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

Should the RTF output include directives for the document pages? This is
\code{TRUE} by default.}

\item{incl_body}{\emph{Include RTF body}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

An option to include the body of RTF document. By default, this is \code{TRUE}.}
}
\description{
Get the RTF content from a \code{gt_tbl} object as as a single-element character
vector. This object can be used with \code{writeLines()} to generate a valid .rtf
file that can be opened by RTF readers.
}
\section{Examples}{


Use a subset of the \code{\link{gtcars}} dataset to create a \strong{gt} table. Add a header
with \code{\link[=tab_header]{tab_header()}} and then export the table as RTF code using the
\code{as_rtf()} function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tab_rtf <-
  gtcars |>
  dplyr::select(mfr, model) |>
  dplyr::slice(1:2) |>
  gt() |>
  tab_header(
    title = md("Data listing from **gtcars**"),
    subtitle = md("`gtcars` is an R dataset")
  ) |>
  as_rtf()
}\if{html}{\out{</div>}}
}

\section{Function ID}{

13-4
}

\section{Function Introduced}{

\code{v0.2.0.5} (March 31, 2020)
}

\seealso{
Other table export functions: 
\code{\link{as_gtable}()},
\code{\link{as_latex}()},
\code{\link{as_raw_html}()},
\code{\link{as_word}()},
\code{\link{extract_body}()},
\code{\link{extract_cells}()},
\code{\link{extract_summary}()},
\code{\link{gtsave}()}
}
\concept{table export functions}
