/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the COPYING file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
#ifndef H5FDioc_H
#define H5FDioc_H
#include "H5FDsubfiling.h"
#ifdef H5_HAVE_IOC_VFD
#define H5FD_IOC (H5FDperform_init(H5FD_ioc_init))
#else
#define H5FD_IOC (H5I_INVALID_HID)
#endif
#define H5FD_IOC_NAME "ioc"
#ifdef H5_HAVE_IOC_VFD
#ifndef H5FD_IOC_FAPL_MAGIC
#define H5FD_IOC_CURR_FAPL_VERSION 1
#define H5FD_IOC_FAPL_MAGIC 0xFED21331
#endif
#define H5FD_IOC_DEFAULT_THREAD_POOL_SIZE 4
#define H5FD_IOC_THREAD_POOL_SIZE "H5FD_IOC_THREAD_POOL_SIZE"
//! <!-- [H5FD_ioc_config_t_snip] -->
typedef struct H5FD_ioc_config_t {
    uint32_t magic;
    uint32_t version;
    int32_t  thread_pool_size;
} H5FD_ioc_config_t;
//! <!-- [H5FD_ioc_config_t_snip] -->
#ifdef __cplusplus
extern "C" {
#endif
H5_DLL hid_t H5FD_ioc_init(void);
H5_DLL herr_t H5Pset_fapl_ioc(hid_t fapl_id, H5FD_ioc_config_t *vfd_config);
H5_DLL herr_t H5Pget_fapl_ioc(hid_t fapl_id, H5FD_ioc_config_t *config_out);
H5_DLL void H5FD_ioc_begin_thread_exclusive(void);
H5_DLL void H5FD_ioc_end_thread_exclusive(void);
#ifdef __cplusplus
}
#endif
#endif
#endif
