% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctstm.R
\name{CtstmTrans}
\alias{CtstmTrans}
\title{An \code{R6} base class for continuous time state transition models}
\format{
An \code{\link[R6:R6Class]{R6::R6Class}} object.
}
\description{
Contains methods that can be used to summarize both individual- and cohort-level
continuous time state transition models. That is, this class is relevant for
both Markov and semi-Markov multi-state models and does not depend on the
methodology used for prediction of state probabilities.
}
\seealso{
\code{\link[=create_IndivCtstmTrans]{create_IndivCtstmTrans()}}, \code{\link{IndivCtstmTrans}}
}
\keyword{internal}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-CtstmTrans-hazard}{\code{CtstmTrans$hazard()}}
\item \href{#method-CtstmTrans-cumhazard}{\code{CtstmTrans$cumhazard()}}
\item \href{#method-CtstmTrans-clone}{\code{CtstmTrans$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CtstmTrans-hazard"></a>}}
\if{latex}{\out{\hypertarget{method-CtstmTrans-hazard}{}}}
\subsection{Method \code{hazard()}}{
Predict the hazard functions for each health state transition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CtstmTrans$hazard(t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{A numeric vector of times.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.table} with columns \code{transition_id},
\code{sample}, \code{strategy_id}, \code{grp_id}, \code{t}, and \code{hazard}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CtstmTrans-cumhazard"></a>}}
\if{latex}{\out{\hypertarget{method-CtstmTrans-cumhazard}{}}}
\subsection{Method \code{cumhazard()}}{
Predict the cumulative hazard functions for each health state transition.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CtstmTrans$cumhazard(t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{t}}{A numeric vector of times.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{data.table} with columns \code{transition_id},
\code{sample}, \code{strategy_id}, \code{grp_id}, \code{t}, and \code{cumhazard}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-CtstmTrans-clone"></a>}}
\if{latex}{\out{\hypertarget{method-CtstmTrans-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{CtstmTrans$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
