% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postHoc.R
\name{postHoc}
\alias{postHoc}
\alias{print.resposthoc}
\alias{summary.resposthoc}
\alias{plot.resposthoc}
\title{Perform Post Hoc Inference}
\usage{
postHoc(resdiff, clusters, alpha, fill = FALSE, stepDown = TRUE)

\method{print}{resposthoc}(x, ...)

\method{summary}{resposthoc}(object, ...)

\method{plot}{resposthoc}(x, ...)
}
\arguments{
\item{resdiff}{An object of class \code{resdiff} obtained from the
function \code{\link{performTest}}.}

\item{clusters}{A vector corresponding to a clustering of resdiff rows.}

\item{alpha}{A number between 0 and 1 at which the computed post hoc bounds
will be valid.}

\item{fill}{A boolean value. If TRUE (the default), enforce the total 
number of tests to be \emph{p*(p+1)/2} by adding ones to the p-value vector 
for non tested entries.}

\item{stepDown}{A boolean value. If FALSE, the single step Simes method is
used. If TRUE (the default), the step-down Simes method is used. The latter
is more powerful when the signal is strong.}

\item{x}{a \code{resposthoc} object to plot}

\item{...}{not used}

\item{object}{a \code{resposthoc} object to summarize}
}
\value{
An object of class \code{resposthoc} containing a matrix with true
positive proportions for each interaction and a dataframe with the following
entries:
\item{region1}{The first bin of the interaction.}
\item{region2}{The second bin of the interaction.}
\item{clust}{The cluster the interaction belongs to.}
\item{TDP}{The minimal post hoc true discovery (positive) proportion of the cluster
the interaction belongs to.}
\item{p.value}{The p-value of the diffHic test.}
\item{p.adj}{The adjusted p-value of the diffHic test.}
\item{logFC}{The log2-fold-change of the interaction.}
\item{meanlogFC}{The mean of the log2-fold-change for the cluster the
interaction belongs to.}
\item{varlogFC}{The variance of the log2-fold-change for the cluster the
interaction belongs to.}
\item{propPoslogFC}{The proportion of interactions with positive
log2-fold-change in the cluster the interaction belongs to.}
}
\description{
This function performs post-hoc inference on all provided clusters
using \code{\link{performTest}} results.
}
\examples{
data("pighic")
resdiff <- performTest(pighic$data, pighic$conditions)
\donttest{res2D <- AggloClust2D(pighic$data)
if (!is.null(res2D)) { # in case Python or modules are not available
  clusters <- res2D$clustering
  alpha <- 0.05
  resposthoc <- postHoc(resdiff, clusters, alpha)
  resposthoc
  summary(resposthoc)
  plot(resposthoc)
}}
}
\author{
Élise Jorge \email{elise.jorge@inrae.fr}\cr
Sylvain Foissac \email{sylvain.foissac@inrae.fr}\cr
Toby Dylan Hocking \email{toby.hocking@r-project.org}\cr
Pierre Neuvial \email{pierre.neuvial@math.univ-toulouse.fr}\cr
Nathalie Vialaneix \email{nathalie.vialaneix@inrae.fr}
}
