% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/htmlwidgets.R
\name{onRender}
\alias{onRender}
\title{Execute custom JavaScript code after rendering}
\usage{
onRender(x, jsCode)
}
\arguments{
\item{x}{An HTML Widget object}

\item{jsCode}{Character vector containing JavaScript code (see Details)}
}
\value{
The modified widget object
}
\description{
Use this function to supplement the widget's built-in JavaScript rendering
logic with additional custom JavaScript code, just for this specific widget
object.
}
\details{
The \code{jsCode} parameter must be a valid JavaScript expression
  that returns a function.

  The function will be invoked with two arguments: the first is the widget's
  main HTML element, and the second is the data to be rendered (the \code{x}
  parameter in \code{createWidget}). When the function is invoked, the
  \code{this} will be the widget instance object.
}
\examples{
\dontrun{
library(leaflet)

leaflet() \%>\% addTiles() \%>\%
  onRender("
    function(el, x) {
      // Navigate the map to the user's location
      this.locate({setView: true});
    }
  ")
}

}
\seealso{
\code{\link{onStaticRenderComplete}}, for writing custom JavaScript
  that involves multiple widgets.
}

