% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/server.R
\name{WebServer}
\alias{WebServer}
\title{WebServer class}
\description{
This class represents a web server running one application. Multiple servers
can be running at the same time.
}
\section{Methods}{


\describe{
\item{\code{initialize(host, port, app)}}{
Create a new \code{WebServer} object. \code{app} is an httpuv application
object as described in \code{\link{startServer}}.
}
\item{\code{getHost()}}{Return the value of \code{host} that was passed to
\code{initialize()}.
}
\item{\code{getPort()}}{Return the value of \code{port} that was passed to
\code{initialize()}.
}
\item{\code{stop()}}{Stops a running server.}
\item{\code{isRunning()}}{Returns TRUE if the server is currently running.}
\item{\code{getStaticPaths()}}{Returns a list of \code{\link{staticPath}}
objects for the server.
}
\item{\code{setStaticPath(..., .list = NULL)}}{Sets a static path for the
current server. Each static path can be given as a named argument, or as
an named item in \code{.list}. If there already exists a static path with
the same name, it will be replaced.
}
\item{\code{removeStaticPath(path)}}{Removes a static path with the given
name.
}
\item{\code{getStaticPathOptions()}}{Returns a list of default
\code{staticPathOptions} for the current server. Each static path will
use these options by default, but they can be overridden for each static
path.
}
\item{\code{setStaticPathOption(..., .list = NULL)}}{Sets one or more
static path options. Each option can be given as a named argument, or as
a named item in \code{.list}.
}
}
}

\seealso{
\code{\link{Server}} and \code{\link{PipeServer}}.
}
\keyword{internal}
\section{Super class}{
\code{\link[httpuv:Server]{httpuv::Server}} -> \code{WebServer}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{WebServer$new()}}
\item \href{#method-getHost}{\code{WebServer$getHost()}}
\item \href{#method-getPort}{\code{WebServer$getPort()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="getStaticPathOptions">}\href{../../httpuv/html/Server.html#method-getStaticPathOptions}{\code{httpuv::Server$getStaticPathOptions()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="getStaticPaths">}\href{../../httpuv/html/Server.html#method-getStaticPaths}{\code{httpuv::Server$getStaticPaths()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="isRunning">}\href{../../httpuv/html/Server.html#method-isRunning}{\code{httpuv::Server$isRunning()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="removeStaticPath">}\href{../../httpuv/html/Server.html#method-removeStaticPath}{\code{httpuv::Server$removeStaticPath()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="setStaticPath">}\href{../../httpuv/html/Server.html#method-setStaticPath}{\code{httpuv::Server$setStaticPath()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="setStaticPathOption">}\href{../../httpuv/html/Server.html#method-setStaticPathOption}{\code{httpuv::Server$setStaticPathOption()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="httpuv" data-topic="Server" data-id="stop">}\href{../../httpuv/html/Server.html#method-stop}{\code{httpuv::Server$stop()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WebServer$new(host, port, app, quiet = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getHost"></a>}}
\if{latex}{\out{\hypertarget{method-getHost}{}}}
\subsection{Method \code{getHost()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WebServer$getHost()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getPort"></a>}}
\if{latex}{\out{\hypertarget{method-getPort}{}}}
\subsection{Method \code{getPort()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{WebServer$getPort()}\if{html}{\out{</div>}}
}

}
}
