% Generated by roxygen2 (4.0.1): do not edit by hand
\name{httr_options}
\alias{curl_docs}
\alias{httr_options}
\title{List available options.}
\usage{
httr_options()

curl_docs(x)
}
\arguments{
\item{x}{An option name (either short or full).}
}
\value{
A data frame with three columns:
\item{httr}{The short name used in httr}
\item{libcurl}{The full name used by libcurl}
\item{type}{The type of R object that the option accepts}
}
\description{
This function lists all available options for \code{\link{config}()}.
It provides both the short R name which you use with httr, and the longer
Curl name, which is useful when searching the documentation. \code{curl_doc}
opens a link to the libcurl documentation for an option in your browser.
}
\details{
RCurl and httr use slightly different names to libcurl: the initial
\code{CURLOPT_} is removed, all underscores are converted to periods and
the option is given in lower case.  Thus "CURLOPT_SSLENGINE_DEFAULT"
becomes "sslengine.default".
}
\examples{
httr_options()

# Use curl_docs to read the curl documentation for each option.
# You can use either the httr or curl option name.
curl_docs("userpwd")
curl_docs("CURLOPT_USERPWD")
}

