% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ichimoku.R
\name{gplot}
\alias{gplot}
\title{gplot Plot Ichimoku Cloud Chart with Weekend Gaps}
\usage{
gplot(
  object,
  window,
  ticker,
  message,
  theme = c("original", "dark", "solarized", "mono"),
  ...
)
}
\arguments{
\item{object}{an object of class 'ichimoku'.}

\item{window}{(optional) a date-time window to subset the plot, in ISO-8601
compatible range strings of the format used for 'xts' objects, for example
"2020-02-15/2020-08-15" or "2020-02-15/", "/2020-08" or "2020-07".}

\item{ticker}{(optional) specify a ticker (or other text) to include in the
chart heading. If not set, the ticker saved within the ichimoku object
will be used.}

\item{message}{(optional) specify a chart message to display under the title.}

\item{theme}{[default 'original'] with alternative choices of 'dark',
'solarized' or 'mono'.}

\item{...}{other arguments not used by this method.}
}
\value{
Returns a ggplot2 object with S3 classes 'gg' and 'ggplot'.
}
\description{
Deprecated plot method for Ichimoku Kinko Hyo cloud charts with weekend gaps
    for non-trading days. This feature is deprecated and this function is
    included as a convenience only.
}
\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")
gplot(cloud)

}
