% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{sample_islands}
\alias{sample_islands}
\title{A graph with subgraphs that are each a random graph.}
\usage{
sample_islands(islands.n, islands.size, islands.pin, n.inter)
}
\arguments{
\item{islands.n}{The number of islands in the graph.}

\item{islands.size}{The size of islands in the graph.}

\item{islands.pin}{The probability to create each possible edge into each
island.}

\item{n.inter}{The number of edges to create between two islands.}
}
\value{
An igraph graph.
}
\description{
Create a number of Erdős-Rényi random graphs with identical parameters, and
connect them with the specified number of edges.
}
\section{Examples}{

\preformatted{
g <- sample_islands(3, 10, 5/10, 1)
oc <- cluster_optimal(g)
oc
}
}

\seealso{
\code{\link[=sample_gnp]{sample_gnp()}}

Random graph models (games)
\code{\link{bipartite_gnm}()},
\code{\link{erdos.renyi.game}()},
\code{\link{sample_}()},
\code{\link{sample_bipartite}()},
\code{\link{sample_chung_lu}()},
\code{\link{sample_correlated_gnp}()},
\code{\link{sample_correlated_gnp_pair}()},
\code{\link{sample_degseq}()},
\code{\link{sample_dot_product}()},
\code{\link{sample_fitness}()},
\code{\link{sample_fitness_pl}()},
\code{\link{sample_forestfire}()},
\code{\link{sample_gnm}()},
\code{\link{sample_gnp}()},
\code{\link{sample_grg}()},
\code{\link{sample_growing}()},
\code{\link{sample_hierarchical_sbm}()},
\code{\link{sample_k_regular}()},
\code{\link{sample_last_cit}()},
\code{\link{sample_pa}()},
\code{\link{sample_pa_age}()},
\code{\link{sample_pref}()},
\code{\link{sample_sbm}()},
\code{\link{sample_smallworld}()},
\code{\link{sample_traits_callaway}()},
\code{\link{sample_tree}()}
}
\author{
Samuel Thiriot
}
\concept{games}
\keyword{graphs}
\section{Related documentation in the C library}{\href{https://igraph.org/c/html/0.10.17/igraph-Generators.html#igraph_simple_interconnected_islands_game}{\code{simple_interconnected_islands_game()}}.}

