% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary.imptree}
\alias{summary.imptree}
\alias{print.summary.imptree}
\title{Classification with Imprecise Probabilities}
\usage{
\method{summary}{imptree}(object, utility = 0.65,
  dominance = c("strong", "max"), ...)

\method{print}{summary.imptree}(x, ...)
}
\arguments{
\item{object}{An object of class \code{imptree}. See details.}

\item{utility}{Utility for the utility based accuracy measure for
a vacuous prediction result (default: 0.65).}

\item{dominance}{Dominace criterion to be applied when predicting
classes. This may either be \code{"strong"} (default) or
\code{"max"}. See details at \code{\link{predict.imptree}}.}

\item{\dots}{Further arguments are ignored at the moment.}

\item{x}{an object of class \code{summary.imptree}}
}
\value{
A named list of class \code{summary.imptree} containing
the tree creation call, accuracy on the training data, meta data
and supplied the utility and dominance criterion for evaluation.
\item{call}{Call to create the tree}
\item{utility}{Supplied utility, or its default value}
\item{dominance}{Supplied dominace criterion, or its 
default value}
\item{sizes}{List containing the overall number and number of 
indeterminate predictions on training data}
\item{acc}{named vector containing the accuracy measures 
on training data with nicer names (without size information)
(see \code{\link{predict.imptree}})}
\item{meta}{named vector containing the tree's depth, 
number of leaves and number of nodes}

The printing function returns the
\code{summary.imptree} object invisibly.
}
\description{
Summary function for an imptree object, assesses 
accuracy achieved on training data and further tree properties.
}
\details{
An existence check on the stored C++ object reference is carried
out at first. If the reference is not valid the original call
for \code{"object"} is printed as error.
}
\examples{
data("carEvaluation")

## create a tree with IDM (s=1) to full size
## carEvaluation, leaving the first 10 observations out
ip <- imptree(acceptance~., data = carEvaluation[-(1:10),], 
  method="IDM", method.param = list(splitmetric = "globalmax", s = 1), 
  control = list(depth = NULL, minbucket = 1))

## summary including prediction on training data
summary(ip)                       # default prediction
summary(ip, dominance = "max")    # different prediction parameter

}
\seealso{
\code{\link{imptree}}, \code{\link{predict.imptree}},
for information on a single node \code{\link{node_imptree}}
}
\author{
Paul Fink \email{Paul.Fink@stat.uni-muenchen.de}
}
\keyword{tree}
