% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combMyTree.R
\name{combMyTree}
\alias{combMyTree}
\title{Graft Polytomies on Tips of Phylogeny}
\usage{
combMyTree(phy, data, brlen = 0, annotate = FALSE)
}
\arguments{
\item{phy}{An object of class \code{\link{phylo}}.}

\item{data}{A data frame containing two columns. The entries of one column
must be identical to the tip labels of the phylogeny; the other column
contains the new tip labels. The column are matched
automatically.}

\item{brlen}{A numeric giving the branch lengths for the polytomies.}

\item{annotate}{Logical, if \code{TRUE}, the former tip labels will be turned
into node labels. Note, that this will overwrite existing node labels.}
}
\value{
An object of class \code{\link{phylo}} with \code{nrow(data)} tips.
}
\description{
Graft polytomies on the tips of a class \code{phylo} object.
}
\examples{
data(ips.tree)
## Simulate varying number of intraspecific observations
s <- sapply(1:Ntip(ips.tree), sample, x = 1:3, size = 1)
x <- rep(ips.tree$tip.label, times = s)
x <- data.frame(x, paste0(x, unlist(lapply(s, function(z) 1:z))))
## Create polytomies
tre <- combMyTree(ips.tree, x)
plot(tre, no.margin = TRUE, cex =.5)
}
\seealso{
\code{\link{forceEqualTipHeights}}
}
