% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jrc.R
\name{Session}
\alias{Session}
\title{Session class}
\description{
Objects of this class handle all the incoming and outgoing messages for one active connection. 
Please, avoid creating instances of this class manually. Each \code{Session} object is created when
a WebSocket is opened and serves as a wrapper around it. A manually created object will not have
a WebSocket connection and thus are not functional.

All sessions are stored within an object of class \code{\link{App}} and cannot exist and function without it.
One can manipulate a session directly, using its methods described below, via methods of the corresponding 
\code{\link{App}} object or the provided wrapper function (links to them can be found in the Methods section).
}
\section{Fields}{

\describe{
   \item{\code{id}}{
      Automatically generated ID for this session. ID is a random combination of 6 letters or numbers.
      Please, do not change the value of this field.
   }
   \item{\code{lastActive}}{
      Time of the last received message from the session's WebSocket. The timestamp is generated by the
      \code{\link[base]{Sys.time}} function.
   }
   \item{\code{startTime}}{
      Time when this session has been started (generated by the \code{\link[base]{Sys.time}} function).
   }
}
}

\section{Methods}{

\describe{
  \item{\code{getMessageIds()}}{
     Returns IDs of all currently stored messages. ID is a combination of 6 random letters and numbers
     generated when the message is stored. See also \code{\link{getMessageIds}}.
  }
  \item{\code{authorize(messageId = NULL, show = FALSE)}}{ 
     Authorizes evaluation of a message. Check \code{\link{authorize}} for more information.
  }
  \item{\code{removeMessage(messageId = NULL)}}{
     Removes a stored message. This can also be done with the \code{\link{authorize}} function (set
     \code{show = TRUE} and then select the ``Ignore message'' option). See also \code{\link{removeMessage}}.
  }
  \item{\code{sendCommand(command, wait = 0)}}{
     Sends a JavaScript command to be evaluated on the web page. Check 
     \code{\link{sendCommand}} for more information.
  }
  \item{\code{callFunction(name, arguments = NULL, assignTo = NULL, wait = 0, thisArg = NULL,  ...)}}{
     Calls an existing JavaScript
     function on the web page. Check \code{\link{callFunction}} for more information.
  }
  \item{\code{sendData(variableName, variable, wait = 0, keepAsVector = FALSE, rowwise = TRUE)}}{
     Sends data and assigns it to 
     a variable on the web page. Check \code{\link{sendData}} for more information.
  }
  \item{\code{sendHTML(html, wait = 0)}}{
     Sends HTML code that will be appended to the web page. Check \code{\link{sendHTML}} for 
     more information.
  }
  \item{\code{sessionVariables(vars = NULL, varName = NULL, remove = NULL)}}{
     Sets or returns variables that are used (read or modified) only by this session. If both arguments are
     \code{NULL}, returns environment for this session. If \code{vars} is a named list, adds this variables to the
     session environment. If \code{varName} is a character, returns a variable with this name how it is seen from
     the session. If the variable doesn't exist, throws an error. If \code{remove} is a vector of characters, removes
     variables with these names from the session environment. One can add variables to the session environment,
     get one back and remove variables with a single function call. Check \code{\link{setSessionVariables}},
     \code{\link{getSessionVariable}}, \code{\link{removeSessionVariables}} for more information.
  }
 \item{\code{setLimits(limits)}}{
      Sets limits for memory usage, number of simultaneously active connections and amount of messages processed per second. 
      For information about possible arguments, please, check \code{\link{setLimits}}. This method accepts all the same arguments,
      but they should be supplied in a form of list.
   }
}
Note, that \code{Session} class has some other public methods that are not mentioned in this list. These methods are
intended to be used only by other functions of \code{jrc} package and therefore are not documented.
}

