% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relative_risk.R
\name{a_relative_risk}
\alias{a_relative_risk}
\alias{relative_risk}
\alias{s_relative_risk}
\title{Relative risk estimation}
\usage{
a_relative_risk(
  df,
  .var,
  ref_path,
  .spl_context,
  ...,
  .stats = NULL,
  .formats = NULL,
  .labels = NULL,
  .indent_mods = NULL
)

s_relative_risk(
  df,
  .var,
  .ref_group,
  .in_ref_col,
  variables = list(strata = NULL),
  conf_level = 0.95,
  method = "cmh",
  weights_method = "cmh"
)
}
\arguments{
\item{df}{(\code{data.frame})\cr input data frame.}

\item{.var}{(\code{string})\cr name of the response variable.}

\item{ref_path}{(\code{character})\cr path to the reference group.}

\item{.spl_context}{(\code{environment})\cr split context environment.}

\item{...}{Additional arguments passed to the statistics function.}

\item{.stats}{(\code{character})\cr statistics to calculate.}

\item{.formats}{(\code{list})\cr formats for the statistics.}

\item{.labels}{(\code{list})\cr labels for the statistics.}

\item{.indent_mods}{(\code{list})\cr indentation modifications for the statistics.}

\item{.ref_group}{(\code{data.frame})\cr reference group data frame.}

\item{.in_ref_col}{(\code{logical})\cr whether the current column is the reference column.}

\item{variables}{(\code{list})\cr list with strata variable names.}

\item{conf_level}{(\code{numeric})\cr confidence level for the confidence interval.}

\item{method}{(\code{string})\cr method to use for relative risk calculation.}

\item{weights_method}{(\code{string})\cr method to use for weights calculation in stratified analysis.}
}
\value{
\itemize{
\item \code{a_relative_risk()} returns the corresponding list with formatted \code{\link[rtables:CellValue]{rtables::CellValue()}}.
}

\itemize{
\item \code{s_relative_risk()} returns a named list of elements \code{rel_risk_ci} and \code{pval}.
}
}
\description{
The analysis function \code{\link[=a_relative_risk]{a_relative_risk()}} is used to create a layout element
to estimate the relative risk for response within a studied population. Only
the CMH method is available currently.
The primary analysis variable, \code{vars}, is a logical variable indicating
whether a response has occurred for each record.
A stratification variable must be supplied via the
\code{strata} element of the \code{variables} argument.
}
\details{
The variance of the CMH relative risk estimate is calculated using
the Greenland and Robins (1985) variance estimation.
}
\section{Functions}{
\itemize{
\item \code{a_relative_risk()}: Formatted analysis function which is used as \code{afun}. Note that the
junco specific \code{ref_path} and \code{.spl_context} arguments are used for reference column information.

\item \code{s_relative_risk()}: Statistics function estimating the relative risk for response.

}}
\note{
This has been adapted from the \code{odds_ratio} functions in the \code{tern} package.
}
\examples{
nex <- 100
dta <- data.frame(
  "rsp" = sample(c(TRUE, FALSE), nex, TRUE),
  "grp" = sample(c("A", "B"), nex, TRUE),
  "f1" = sample(c("a1", "a2"), nex, TRUE),
  "f2" = sample(c("x", "y", "z"), nex, TRUE),
  stringsAsFactors = TRUE
)

l <- basic_table() |>
  split_cols_by(var = "grp") |>
  analyze(
    vars = "rsp",
    afun = a_relative_risk,
    extra_args = list(
      conf_level = 0.90,
      variables = list(strata = "f1"),
      ref_path = c("grp", "B")
    )
  )

build_table(l, df = dta)
nex <- 100
dta <- data.frame(
  "rsp" = sample(c(TRUE, FALSE), nex, TRUE),
  "grp" = sample(c("A", "B"), nex, TRUE),
  "f1" = sample(c("a1", "a2"), nex, TRUE),
  "f2" = sample(c("x", "y", "z"), nex, TRUE),
  stringsAsFactors = TRUE
)

s_relative_risk(
  df = subset(dta, grp == "A"),
  .var = "rsp",
  .ref_group = subset(dta, grp == "B"),
  .in_ref_col = FALSE,
  variables = list(strata = c("f1", "f2")),
  conf_level = 0.90
)
}
