% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.R
\name{summary.fitted_dlm}
\alias{summary.fitted_dlm}
\title{Summary for a fitted kDGLM model}
\usage{
\method{summary}{fitted_dlm}(
  object,
  t = object$t,
  lag = -1,
  metric.lag = 1,
  metric.cutoff = floor(object$t/10),
  pred.cred = 0.95,
  ...
)
}
\arguments{
\item{object}{A fitted_dlm object.}

\item{t}{Integer: The time index for the latent states.}

\item{lag}{Integer: The number of steps ahead used for the evaluating the latent states. Use lag<0 for the smoothed distribution, If lag==0 for the filtered distribution and lag=h for the h-step-ahead prediction.}

\item{metric.lag}{Integer: The number of steps ahead used for the evaluating the predictions used when calculating metrics. Use metric.lag<0 for the smoothed distribution, If metric.lag==0 for the filtered distribution and metric.lag=h for the h-step-ahead prediction.}

\item{metric.cutoff}{Integer: The cutoff time index for the metric calculation. Values before that time will be ignored.}

\item{pred.cred}{numeric: The credibility interval to be used for the interval score.}

\item{...}{Extra arguments passed to the coef method.#'}
}
\value{
No return value, called to print a summary of the fitted kDGLM model.
}
\description{
Prints a report for a fitted_dlm object.
}
\examples{

data <- c(AirPassengers)

level <- polynomial_block(rate = 1, order = 2, D = 0.95)
season <- harmonic_block(rate = 1, order = 2, period = 12, D = 0.975)

outcome <- Poisson(lambda = "rate", data)

fitted.data <- fit_model(level, season,
  AirPassengers = outcome
)
summary(fitted.data)

}
\seealso{
Other auxiliary visualization functions for the fitted_dlm class: 
\code{\link{plot.dlm_coef}()},
\code{\link{plot.fitted_dlm}()},
\code{\link{summary.searched_dlm}()}
}
\concept{auxiliary visualization functions for the fitted_dlm class}
