% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-merge.R
\name{layer_dot}
\alias{layer_dot}
\title{Layer that computes a dot product between samples in two tensors.}
\usage{
layer_dot(inputs, axes, normalize = FALSE, ...)
}
\arguments{
\item{inputs}{A list of input tensors (at least 2). Can be missing.}

\item{axes}{Integer or list of integers, axis or axes along which to take the
dot product.}

\item{normalize}{Whether to L2-normalize samples along the dot product axis
before taking the dot product. If set to TRUE, then the output of the dot
product is the cosine proximity between the two samples.}

\item{...}{Standard layer arguments (must be named).}
}
\value{
If \code{inputs} is supplied: A tensor, the dot product of the samples
from the inputs. If \code{inputs} is missing, a keras layer instance is
returned.
}
\description{
Layer that computes a dot product between samples in two tensors.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/dot}
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/Dot}
\item \url{https://keras.io/api/layers/merging_layers/dot/}
}

Other merge layers: 
\code{\link{layer_average}()},
\code{\link{layer_concatenate}()},
\code{\link{layer_maximum}()},
\code{\link{layer_minimum}()},
\code{\link{layer_multiply}()},
\code{\link{layer_subtract}()}
}
\concept{merge layers}
