% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers-recurrent-cells.R
\name{layer_simple_rnn_cell}
\alias{layer_simple_rnn_cell}
\title{Cell class for SimpleRNN}
\usage{
layer_simple_rnn_cell(
  units,
  activation = "tanh",
  use_bias = TRUE,
  kernel_initializer = "glorot_uniform",
  recurrent_initializer = "orthogonal",
  bias_initializer = "zeros",
  kernel_regularizer = NULL,
  recurrent_regularizer = NULL,
  bias_regularizer = NULL,
  kernel_constraint = NULL,
  recurrent_constraint = NULL,
  bias_constraint = NULL,
  dropout = 0,
  recurrent_dropout = 0,
  ...
)
}
\arguments{
\item{units}{Positive integer, dimensionality of the output space.}

\item{activation}{Activation function to use.
Default: hyperbolic tangent (\code{tanh}).
If you pass \code{NULL}, no activation is applied
(ie. "linear" activation: \code{a(x) = x}).}

\item{use_bias}{Boolean, (default \code{TRUE}), whether the layer uses a bias vector.}

\item{kernel_initializer}{Initializer for the \code{kernel} weights matrix,
used for the linear transformation of the inputs. Default:
\code{glorot_uniform}.}

\item{recurrent_initializer}{Initializer for the \code{recurrent_kernel}
weights matrix, used for the linear transformation of the recurrent state.
Default: \code{orthogonal}.}

\item{bias_initializer}{Initializer for the bias vector. Default: \code{zeros}.}

\item{kernel_regularizer}{Regularizer function applied to the \code{kernel} weights
matrix. Default: \code{NULL}.}

\item{recurrent_regularizer}{Regularizer function applied to the
\code{recurrent_kernel} weights matrix. Default: \code{NULL}.}

\item{bias_regularizer}{Regularizer function applied to the bias vector. Default:
\code{NULL}.}

\item{kernel_constraint}{Constraint function applied to the \code{kernel} weights
matrix. Default: \code{NULL}.}

\item{recurrent_constraint}{Constraint function applied to the \code{recurrent_kernel}
weights matrix. Default: \code{NULL}.}

\item{bias_constraint}{Constraint function applied to the bias vector. Default:
\code{NULL}.}

\item{dropout}{Float between 0 and 1. Fraction of the units to drop for the linear
transformation of the inputs. Default: 0.}

\item{recurrent_dropout}{Float between 0 and 1. Fraction of the units to drop for
the linear transformation of the recurrent state. Default: 0.}

\item{...}{standard layer arguments.}
}
\description{
Cell class for SimpleRNN
}
\details{
See \href{https://www.tensorflow.org/guide/keras/rnn}{the Keras RNN API guide}
for details about the usage of RNN API.

This class processes one step within the whole time sequence input, whereas
\code{tf.keras.layer.SimpleRNN} processes the whole sequence.
}
\seealso{
\itemize{
\item \url{https://www.tensorflow.org/api_docs/python/tf/keras/layers/SimpleRNNCell}
\item \url{https://keras.io/api/layers}
}

Other RNN cell layers: 
\code{\link{layer_gru_cell}()},
\code{\link{layer_lstm_cell}()},
\code{\link{layer_stacked_rnn_cells}()}
}
\concept{RNN cell layers}
