% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{initialize,LandsepiParams-method}
\alias{initialize,LandsepiParams-method}
\title{LandsepiParams}
\usage{
\S4method{initialize}{LandsepiParams}(
  .Object,
  Landscape = st_sf(st_sfc()),
  Croptypes = data.frame(),
  Cultivars = data.frame(matrix(ncol = length(.cultivarsColNames), nrow = 0, dimnames =
    list(NULL, .cultivarsColNames))),
  CultivarsGenes = data.frame(),
  Genes = data.frame(matrix(ncol = length(.geneColNames), nrow = 0, dimnames =
    list(NULL, .geneColNames))),
  Pathogen = list(name = "no pathogen", survival_prob = 0, repro_sex_prob = 0,
    infection_rate = 0, propagule_prod_rate = 0, latent_period_exp = 0, latent_period_var
    = 0, infectious_period_exp = 0, infectious_period_var = 0, sigmoid_kappa = 0,
    sigmoid_sigma = 0, sigmoid_plateau = 1),
  PI0 = 0,
  DispHost = vector(),
  DispPatho = vector(),
  OutputDir = normalizePath(character(getwd())),
  OutputGPKG = "landsepi_landscape.gpkg",
  Outputs = list(epid_outputs = "", evol_outputs = "", thres_breakdown = NA, GLAnoDis =
    NA, audpc100S = NA),
  TimeParam = list(),
  Seed = NULL,
  ...
)
}
\arguments{
\item{.Object}{a LandsepiParam object.}

\item{Landscape}{a landscape as sf object.}

\item{Croptypes}{a dataframe with three columns named 'croptypeID' for croptype index,
'cultivarID' for cultivar index and 'proportion' for the proportion of the cultivar
within the croptype.}

\item{Cultivars}{a dataframe of parameters associated with each host genotype
(i.e. cultivars, lines)
when cultivated in pure crops.}

\item{CultivarsGenes}{a list containing, for each host genotype, the indices of
carried resistance genes.}

\item{Genes}{a data.frame of parameters associated with each resistance gene and with
the evolution of each corresponding pathogenicity gene.}

\item{Pathogen}{a list of pathogen aggressiveness parameters on a susceptible host
for a pathogen genotype not adapted to resistance.}

\item{PI0}{initial probability for the first host (whose index is 0) to be infectious
(i.e. state I) at the beginning of the simulation. Must be between 0 and 1.}

\item{DispHost}{a vectorized matrix giving the probability of host dispersal
from any field of the landscape to any other field}

\item{DispPatho}{a vectorized matrix giving the probability of pathogen dispersal
from any field of the landscape to any other field.}

\item{OutputDir}{the directory for simulation outputs}

\item{OutputGPKG}{the name of the output GPKG file containing parameters of the
deployment strategy}

\item{Outputs}{a list of outputs parameters.}

\item{TimeParam}{a list of time parameters.}

\item{Seed}{an integer used as seed value (for random number generator).}

\item{...}{more options}
}
\description{
Creates and initialises a LandespiParams object with default parameters.
}
