% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphics.R
\name{plot_freqPatho}
\alias{plot_freqPatho}
\title{Plotting pathotype frequencies}
\usage{
plot_freqPatho(
  name_gene,
  Nlevels_aggressiveness,
  I_aggrProp,
  nTS,
  Nyears,
  nTSpY
)
}
\arguments{
\item{name_gene}{a string specifying the name of the gene under investigation}

\item{Nlevels_aggressiveness}{number of pathotypes with respect to the gene under investigation}

\item{I_aggrProp}{a matrix giving the frequency of every pathotype (rows) for every time-step (columns)}

\item{nTS}{number of simulated time-steps}

\item{Nyears}{number of simulated cropping seasons}

\item{nTSpY}{number of time-steps per cropping season}
}
\description{
Plots in a .tiff file the dynamics of pathotype frequencies with respect to
pathogen adaptation to a specific resistance gene.
}
\examples{
\dontrun{
freqMatrix <- matrix(0, nrow = 2, ncol = 100)
freqMatrix[2, 26:100] <- (26:100) / 100
freqMatrix[1, ] <- 1 - freqMatrix[2, ]
plot_freqPatho(
  index_gene = 1,
  Nlevels_aggressiveness = 2,
  freqMatrix,
  nTS = 100,
  Nyears = 10,
  nTSpY = 10
)
}
}
