% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-LandsepiParams.R
\name{getMatrixCultivarPatho}
\alias{getMatrixCultivarPatho}
\title{Get the "cultivar/pathogen genotype" compatibility matrix.}
\usage{
getMatrixCultivarPatho(params)
}
\arguments{
\item{params}{a LandsepiParams object.}
}
\value{
an interaction matrix composed of 0 and 1 values.
}
\description{
Build the matrix indicating if infection is possible at the beginning of the season
for every combination of cultivar (rows) and pathogen genotype (columns).
}
\details{
For each cultivar, there is either possibility of infection by the
pathogen genotype (value of 1), or complete protection (value of 0).
}
\examples{
\dontrun{
simul_params <- createSimulParams()
gene1 <- loadGene(name = "MG 1", type = "majorGene")
gene2 <- loadGene(name = "MG 2", type = "majorGene")
genes <- data.frame(rbind(gene1, gene2), stringsAsFactors = FALSE)
simul_params <- setGenes(simul_params, genes)
cultivar1 <- loadCultivar(name = "Susceptible", type = "wheat")
cultivar2 <- loadCultivar(name = "monoResistant1", type = "wheat")
cultivar3 <- loadCultivar(name = "monoResistant2", type = "wheat")
cultivar4 <- loadCultivar(name = "Pyramid", type = "wheat")
cultivars <- data.frame(rbind(cultivar1, cultivar2, cultivar3, cultivar4)
, stringsAsFactors = FALSE)
simul_params <- setCultivars(simul_params, cultivars)
simul_params <- allocateCultivarGenes(simul_params, "monoResistant1", c("MG 1"))
simul_params <- allocateCultivarGenes(simul_params, "monoResistant2", c("MG 2"))
simul_params <- allocateCultivarGenes(simul_params, "Pyramid", c("MG 1", "MG 2"))
getMatrixCultivarPatho(simul_params)
}
}
\seealso{
\link{getMatrixGenePatho}, \link{getMatrixCroptypePatho}, \link{getMatrixPolyPatho}
}
