\name{qqmath}
\alias{qqmath}
\title{ Q-Q Plot with Theoretical Distribution }
\description{
  Quantile-Quantile plot of a sample and a theoretical distribution
}
\synopsis{
qqmath(formula,
             data = parent.frame(),
             allow.multiple = FALSE,
             outer = TRUE,
             auto.key = FALSE,
             aspect = "fill",
             panel = "panel.qqmath",
             prepanel = NULL,
             scales = list(),
             strip = TRUE,
             groups = NULL,
             xlab,
             xlim,
             ylab,
             ylim,
             f.value = NULL,
             distribution = qnorm,
             drop.unused.levels,
             ...,
             default.scales,
             subscripts = !is.null(groups),
             subset = TRUE)
}
\usage{
qqmath(formula, distribution = qnorm, f.value = NULL, \dots)
}
\arguments{
  \item{formula}{formula of the form \code{~ x | g1 * g2 * \ldots},
    where \code{x} must be a numeric.
  }
  \item{distribution}{ a quantile function that takes a vector of
    probabilities as argument and produces the corresponding
    quantiles. Possible values are \code{qnorm}, \code{qunif} etc.
    Distributions with other required arguments need to be passed in as
    user defined functions.  This is also passed in as an argument to
    the panel function (though not used by the default panel function),
    and the prepanel function if specified, for use in the commonly
    used \code{(pre)panel.qqmathline}.
  }
  \item{f.value}{ optional function of a single integer (representing
    sample size), returning a vector of probabilities corresponding to
    which quantiles should be plotted. The typical value for this
    argument is \code{ppoints}, which is also the S-PLUS default. If
    specified, the probabilities generated by this function is used for
    the plotted quantiles, using the \code{quantile} function for the
    sample, and the \code{distribution} argument for the theoretical
    distribution.

    \code{f.value} defaults to \code{NULL}, which has the effect of
    using \code{ppoints} for the quantiles of the theoretical
    distribution, but the exact data values for the sample. This is
    similar to what happens for \code{qqnorm}.

  }
  \item{\dots}{Other arguments}
}
\value{
  An object of class ``trellis''. The `update' method can be used to
  update components of the object and the `print' method (usually called
  by default) will plot it on an appropriate plotting device.
}
\details{
  \code{qqmath} produces a Q-Q plot of the given sample and a
  theoretical distribution.  The default behaviour of \code{qqmath} is
  different from the corresponding S-PLUS function, but is similar to
  \code{qqnorm}. See the entry for \code{f.value} for specifics.

  This and all other high level Trellis functions have several
  arguments in common. These are extensively documented only in the
  help page for \code{xyplot}, which should be consulted to learn more
  detailed usage.
}
\author{Deepayan Sarkar \url{deepayan@stat.wisc.edu}}
\seealso{\code{\link{xyplot}}, \code{\link{panel.qqmath}},
  \code{\link{panel.qqmathline}}, \code{\link{prepanel.qqmathline}},
  \code{\link{Lattice}}, \code{\link{quantile}}
}
\examples{
qqmath(~ rnorm(100), distribution = function(p) qt(p, df = 10))
qqmath(~ height | voice.part, aspect = 1, data = singer,
       prepanel = prepanel.qqmathline,
       panel = function(x, y) {
          panel.qqmathline(y, distribution = qnorm)
          panel.qqmath(x, y)
       })
}
\keyword{dplot}

