% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addProvinceShape.R
\name{addProvinceShape}
\alias{addProvinceShape}
\title{Adds a choropleth map layer for provinces with additional customization options.}
\usage{
addProvinceShape(
  map,
  data,
  adcode = NULL,
  provinceName = NULL,
  layerId = NULL,
  group = NULL,
  valueProperty = NULL,
  labelProperty = NULL,
  labelOptions = leaflet::labelOptions(),
  popupProps = NULL,
  popupOptions = leaflet::popupOptions(),
  scale = c("white", "red"),
  steps = 5,
  mode = "q",
  channelMode = c("rgb", "lab", "hsl", "lch"),
  padding = NULL,
  correctLightness = FALSE,
  bezierInterpolate = FALSE,
  colors = NULL,
  stroke = TRUE,
  color = "#ffffff",
  weight = 1,
  opacity = 0.5,
  fillOpacity = 0.7,
  dashArray = NULL,
  smoothFactor = 1,
  noClip = FALSE,
  pathOptions = leaflet::pathOptions(),
  highlightOptions = leaflet::highlightOptions(weight = 2, color = "#000000", fillOpacity
    = 1, opacity = 1, bringToFront = TRUE, sendToBack = TRUE),
  legendOptions = NULL,
  ...
)
}
\arguments{
\item{map}{The leaflet map object to add the layer to.}

\item{data}{A data frame containing the data to be visualized.}

\item{adcode}{China administrative division code}

\item{provinceName}{A string specifying the column name in the data frame that corresponds to the province names.}

\item{layerId}{An optional string to identify the layer.}

\item{group}{An optional string for grouping data.}

\item{valueProperty}{The property in the geojson data that corresponds to the value to be mapped.}

\item{labelProperty}{The property in the geojson data that will be used for labels.}

\item{labelOptions}{Options for labels, defaults to leaflet's labelOptions.}

\item{popupProps}{A named vector of properties to display in the popup.}

\item{popupOptions}{Options for popups, defaults to leaflet's popupOptions.}

\item{scale}{A vector of colors to use for the scale of the choropleth map.}

\item{steps}{The number of steps for the color scale.}

\item{mode}{The mode for the color scale, can be "q" for quantile, "e" for equal interval, etc.}

\item{channelMode}{The color channel mode, can be "rgb", "lab", "hsl", or "lch".}

\item{padding}{Optional padding for the choropleth layer.}

\item{correctLightness}{A logical value to correct lightness for color scales.}

\item{bezierInterpolate}{Whether to use bezier interpolation for the lines.}

\item{colors}{An optional vector of colors to override the default color scale.}

\item{stroke}{Whether to draw the stroke along the paths.}

\item{color}{The color for the paths, defaults to white.}

\item{weight}{The weight for the paths.}

\item{opacity}{The opacity for the paths.}

\item{fillOpacity}{The fill opacity for the paths.}

\item{dashArray}{An optional array to create dashed lines.}

\item{smoothFactor}{A factor to smooth the factor for the paths.}

\item{noClip}{Whether to disable clipping of the paths.}

\item{pathOptions}{Additional options for the paths, defaults to leaflet's pathOptions.}

\item{highlightOptions}{Options for highlighting features, defaults to leaflet's highlightOptions.}

\item{legendOptions}{Options for the legend.}

\item{...}{Additional arguments passed to other functions.}
}
\value{
The modified leaflet map object with the added layer.
}
\description{
Adds a choropleth map layer for provinces with additional customization options.
}
\examples{


# Plot using province name, match using first two words of field
library(leaflet)
library(leaflet.extras)
library(leafletZH)
data <- data.frame(name = leafletZH::china_province$name, value = runif(34))
backg <- htmltools::tags$style(".leaflet-container { background: #000; }")
leaflet() |>
  addProvinceShape(
    data = data, provinceName = "name", valueProperty = "value",
    popupProps = c("value")
  ) |>
  setView(lng = 110, lat = 40, zoom = 4) |>
  htmlwidgets::prependContent(backg)


# Use adcode to match, adcode can be obtained in leafletZH::china_province
library(leaflet)
library(leaflet.extras)
library(leafletZH)
library(sf)
data <- data.frame(adcode = seq(110000, 150000, 10000), value = runif(5))
leaflet() |>
  leafletZH::addTilesAmap() |>
  addProvinceShape(
    data = data, adcode = "adcode", valueProperty = "value",
    popupProps = c("value")
  ) |>
  setView(lng = 110, lat = 40, zoom = 4)

}
