% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_locations.R
\name{check_locations}
\alias{check_locations}
\title{check supplied locations}
\usage{
check_locations(x, locations)
}
\arguments{
\item{x}{\code{conductanceMatrix}}

\item{locations}{\code{sf} 'POINT' or 'MULTIPOINT', \code{SpatVector}, \code{data.frame} or \code{matrix} containing the locations coordinates}
}
\value{
\code{message}
}
\description{
checks that locations can be reached when calculating least-cost paths
}
\details{
Using the supplied conductanceMatrix and locations, the function checks whether:
(1) the supplied locations are traversable from at least one adjacent cell
(2) the supplied locations are within the extent of the supplied conductanceMatrix
}
\examples{

r <- terra::rast(system.file("extdata/SICILY_1000m.tif", package="leastcostpath"))

slope_cs <- create_slope_cs(x = r, cost_function = "tobler")

locs <- sf::st_sf(geometry = sf::st_sfc(
sf::st_point(c(861534, 4173726)),
sf::st_point(c(897360, 4155813)),
sf::st_point(c(928364, 4138588)),
crs = terra::crs(r)))

check_locations(x = slope_cs, locations = locs)
}
\author{
Joseph Lewis
}
