\name{diammatrix}
\alias{diammatrix}
\title{Find diameters of mobility graphs}
\description{
  'diammatrix' computes the diameters of certain graphs related to
  convergence speed of \code{felm}.
}
\usage{
  diammatrix(flist, approx=TRUE)
}

\arguments{
  \item{flist}{a list of factors defining the dummies.}
  \item{approx}{logical. Approximate diameters are computed.}
}
\value{
  A matrix of dimension K x K where K is \code{length(flist)}.
}

\details{
  Each pair of factors (f1,f2) from \code{flist} defines a bipartite
  graph in which the vertices are the levels of the factors, and two
  vertices are adjacent if they are observed simultaneously. The
  connected components of this graph
  are important for identification of the coefficients for the factor
  levels, i.e. for \code{getfe}. But experience and some trials have led
  the author to speculate that the diameter of the graph (or its largest
  component) is also important for the convergence rate.  Specifically,
  the author suspects that under some assumptions, time to convergence
  goes like the square of the diameter.  At least in the case of two
  factors.
  This function computes the diameter for each pair of factors.  If the
  graph is disconnected, the largest connected component is used. If
  \code{accel=TRUE} (the default), the diameter is approximated from
  below by drawing two sets of 10 random vertices and finding the
  maximum length of the shortest paths between them.
}

\note{
This function is not important to the operation of the package, it is
included for easy experimentation with the convergence rate. 
It requires that the suggested package \pkg{igraph} is attached.
}