% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lasrangecorrection.R
\name{lasrangecorrection}
\alias{lasrangecorrection}
\title{Normalize intensity with a range correction}
\usage{
lasrangecorrection(
  las,
  sensor,
  Rs,
  f = 2.3,
  gpstime = "gpstime",
  elevation = "Z"
)
}
\arguments{
\item{las}{An object of class \link[lidR:LAS-class]{LAS} or \link[lidR:LAScatalog-class]{LAScatalog}.}

\item{sensor}{SpatialPointsDataDrame object containing the coordinates of
the sensor at different timepoints t. The time and elevation are stored as attributes
(default names are  'gpstime' and 'Z'). It can be computed with \link{sensor_tracking}.}

\item{Rs}{numeric. Range of reference.}

\item{f}{numeric. Exponent. Usually between 2 and 3 in vegetation contexts.}

\item{gpstime, elevation}{character. The name of the attributes that store the gpstime of the
position and the elevation of the sensor respectively. If \code{elevation = NULL} the Z coordinates
are searched in the third column of the coordinates matrix of the SpatialPointsDataFrame. This is
useful if read from a format that supports 3 coordinates points.}
}
\value{
An object of class LAS. The attribute 'Intensity' records the normalised intensity. An extra
attribute named 'RawIntensity' records the original intensities.
}
\description{
Normalize intensity with a range correction according to the formula (see references):
\deqn{I_{norm} = I_{obs} (\frac{R}{Rs})^f)}{Inorm = Iobs * (R/Rs)^f}
To achieve the range correction the position of the sensor must be known at different discrete times.
Using the 'gpstime' of each point, the position of the sensor is interpolated from the reference
and a range correction is applied.
}
\examples{
# A valid file properly populated
LASfile <- system.file("extdata", "Topography.laz", package="lidR")
las <- readLAS(LASfile)

# pmin = 15 because it is an extremely tiny file
# strongly decimated to reduce its size. There are
# actually few multiple returns
sensor <- sensor_tracking(las, pmin = 15)

# Here the effect is virtually null because the size of
# the sample is too tiny to notice any effect of range
las <- lasrangecorrection(las, sensor, Rs = 2000)
}
\references{
Gatziolis, D. (2013). Dynamic Range-based Intensity Normalization for Airborne, Discrete Return
Lidar Data of Forest Canopies. Photogrammetric Engineering & Remote Sensing, 77(3), 251–259.
https://doi.org/10.14358/pers.77.3.251
}
